package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.AWSKMSKeyARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KMSEncryptionConfig(awskmsKeyARN: AWSKMSKeyARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.KMSEncryptionConfig = {
    import KMSEncryptionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.KMSEncryptionConfig
      .builder()
      .awskmsKeyARN(AWSKMSKeyARN.unwrap(awskmsKeyARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.KMSEncryptionConfig.ReadOnly =
    zio.aws.firehose.model.KMSEncryptionConfig.wrap(buildAwsValue())
}
object KMSEncryptionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.KMSEncryptionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.KMSEncryptionConfig =
      zio.aws.firehose.model.KMSEncryptionConfig(awskmsKeyARN)
    def awskmsKeyARN: AWSKMSKeyARN
    def getAwskmsKeyARN: ZIO[Any, Nothing, AWSKMSKeyARN] =
      ZIO.succeed(awskmsKeyARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.KMSEncryptionConfig
  ) extends zio.aws.firehose.model.KMSEncryptionConfig.ReadOnly {
    override val awskmsKeyARN: AWSKMSKeyARN =
      zio.aws.firehose.model.primitives.AWSKMSKeyARN(impl.awskmsKeyARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.KMSEncryptionConfig
  ): zio.aws.firehose.model.KMSEncryptionConfig.ReadOnly = new Wrapper(impl)
}
