package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait KeyType {
  def unwrap: software.amazon.awssdk.services.firehose.model.KeyType
}
object KeyType {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.KeyType
  ): zio.aws.firehose.model.KeyType = value match {
    case software.amazon.awssdk.services.firehose.model.KeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.KeyType.AWS_OWNED_CMK =>
      val r = AWS_OWNED_CMK
      r
    case software.amazon.awssdk.services.firehose.model.KeyType.CUSTOMER_MANAGED_CMK =>
      val r = CUSTOMER_MANAGED_CMK
      r
  }
  case object unknownToSdkVersion extends zio.aws.firehose.model.KeyType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.KeyType =
      software.amazon.awssdk.services.firehose.model.KeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_OWNED_CMK extends zio.aws.firehose.model.KeyType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.KeyType =
      software.amazon.awssdk.services.firehose.model.KeyType.AWS_OWNED_CMK
  }
  case object CUSTOMER_MANAGED_CMK extends zio.aws.firehose.model.KeyType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.KeyType =
      software.amazon.awssdk.services.firehose.model.KeyType.CUSTOMER_MANAGED_CMK
  }
}
