package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{BooleanObject, DeliveryStreamName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListDeliveryStreamsResponse(
    deliveryStreamNames: Iterable[DeliveryStreamName],
    hasMoreDeliveryStreams: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsResponse = {
    import ListDeliveryStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsResponse
      .builder()
      .deliveryStreamNames(deliveryStreamNames.map { item =>
        DeliveryStreamName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .hasMoreDeliveryStreams(hasMoreDeliveryStreams: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ListDeliveryStreamsResponse.ReadOnly =
    zio.aws.firehose.model.ListDeliveryStreamsResponse.wrap(buildAwsValue())
}
object ListDeliveryStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ListDeliveryStreamsResponse =
      zio.aws.firehose.model.ListDeliveryStreamsResponse(
        deliveryStreamNames,
        hasMoreDeliveryStreams
      )
    def deliveryStreamNames: List[DeliveryStreamName]
    def hasMoreDeliveryStreams: BooleanObject
    def getDeliveryStreamNames: ZIO[Any, Nothing, List[DeliveryStreamName]] =
      ZIO.succeed(deliveryStreamNames)
    def getHasMoreDeliveryStreams: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(hasMoreDeliveryStreams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsResponse
  ) extends zio.aws.firehose.model.ListDeliveryStreamsResponse.ReadOnly {
    override val deliveryStreamNames: List[DeliveryStreamName] = impl
      .deliveryStreamNames()
      .asScala
      .map { item =>
        zio.aws.firehose.model.primitives.DeliveryStreamName(item)
      }
      .toList
    override val hasMoreDeliveryStreams: BooleanObject =
      impl.hasMoreDeliveryStreams(): BooleanObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsResponse
  ): zio.aws.firehose.model.ListDeliveryStreamsResponse.ReadOnly = new Wrapper(
    impl
  )
}
