package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.BooleanObject
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForDeliveryStreamResponse(
    tags: Iterable[zio.aws.firehose.model.Tag],
    hasMoreTags: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamResponse = {
    import ListTagsForDeliveryStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamResponse
      .builder()
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .hasMoreTags(hasMoreTags: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.ListTagsForDeliveryStreamResponse.ReadOnly =
    zio.aws.firehose.model.ListTagsForDeliveryStreamResponse
      .wrap(buildAwsValue())
}
object ListTagsForDeliveryStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ListTagsForDeliveryStreamResponse =
      zio.aws.firehose.model.ListTagsForDeliveryStreamResponse(
        tags.map { item =>
          item.asEditable
        },
        hasMoreTags
      )
    def tags: List[zio.aws.firehose.model.Tag.ReadOnly]
    def hasMoreTags: BooleanObject
    def getTags: ZIO[Any, Nothing, List[zio.aws.firehose.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
    def getHasMoreTags: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(hasMoreTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamResponse
  ) extends zio.aws.firehose.model.ListTagsForDeliveryStreamResponse.ReadOnly {
    override val tags: List[zio.aws.firehose.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.firehose.model.Tag.wrap(item)
      }
      .toList
    override val hasMoreTags: BooleanObject = impl.hasMoreTags(): BooleanObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamResponse
  ): zio.aws.firehose.model.ListTagsForDeliveryStreamResponse.ReadOnly =
    new Wrapper(impl)
}
