package zio.aws.firehose.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  ReadFromTimestamp,
  DeliveryStartTimestamp,
  TopicName,
  MSKClusterARN
}
import scala.jdk.CollectionConverters._
final case class MSKSourceDescription(
    mskClusterARN: Optional[MSKClusterARN] = Optional.Absent,
    topicName: Optional[TopicName] = Optional.Absent,
    authenticationConfiguration: Optional[
      zio.aws.firehose.model.AuthenticationConfiguration
    ] = Optional.Absent,
    deliveryStartTimestamp: Optional[DeliveryStartTimestamp] = Optional.Absent,
    readFromTimestamp: Optional[ReadFromTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.MSKSourceDescription = {
    import MSKSourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.MSKSourceDescription
      .builder()
      .optionallyWith(
        mskClusterARN.map(value =>
          MSKClusterARN.unwrap(value): java.lang.String
        )
      )(_.mskClusterARN)
      .optionallyWith(
        topicName.map(value => TopicName.unwrap(value): java.lang.String)
      )(_.topicName)
      .optionallyWith(
        authenticationConfiguration.map(value => value.buildAwsValue())
      )(_.authenticationConfiguration)
      .optionallyWith(
        deliveryStartTimestamp.map(value =>
          DeliveryStartTimestamp.unwrap(value): Instant
        )
      )(_.deliveryStartTimestamp)
      .optionallyWith(
        readFromTimestamp.map(value => ReadFromTimestamp.unwrap(value): Instant)
      )(_.readFromTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.MSKSourceDescription.ReadOnly =
    zio.aws.firehose.model.MSKSourceDescription.wrap(buildAwsValue())
}
object MSKSourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.MSKSourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.MSKSourceDescription =
      zio.aws.firehose.model.MSKSourceDescription(
        mskClusterARN.map(value => value),
        topicName.map(value => value),
        authenticationConfiguration.map(value => value.asEditable),
        deliveryStartTimestamp.map(value => value),
        readFromTimestamp.map(value => value)
      )
    def mskClusterARN: Optional[MSKClusterARN]
    def topicName: Optional[TopicName]
    def authenticationConfiguration
        : Optional[zio.aws.firehose.model.AuthenticationConfiguration.ReadOnly]
    def deliveryStartTimestamp: Optional[DeliveryStartTimestamp]
    def readFromTimestamp: Optional[ReadFromTimestamp]
    def getMskClusterARN: ZIO[Any, AwsError, MSKClusterARN] =
      AwsError.unwrapOptionField("mskClusterARN", mskClusterARN)
    def getTopicName: ZIO[Any, AwsError, TopicName] =
      AwsError.unwrapOptionField("topicName", topicName)
    def getAuthenticationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AuthenticationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "authenticationConfiguration",
      authenticationConfiguration
    )
    def getDeliveryStartTimestamp: ZIO[Any, AwsError, DeliveryStartTimestamp] =
      AwsError.unwrapOptionField(
        "deliveryStartTimestamp",
        deliveryStartTimestamp
      )
    def getReadFromTimestamp: ZIO[Any, AwsError, ReadFromTimestamp] =
      AwsError.unwrapOptionField("readFromTimestamp", readFromTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.MSKSourceDescription
  ) extends zio.aws.firehose.model.MSKSourceDescription.ReadOnly {
    override val mskClusterARN: Optional[MSKClusterARN] = zio.aws.core.internal
      .optionalFromNullable(impl.mskClusterARN())
      .map(value => zio.aws.firehose.model.primitives.MSKClusterARN(value))
    override val topicName: Optional[TopicName] = zio.aws.core.internal
      .optionalFromNullable(impl.topicName())
      .map(value => zio.aws.firehose.model.primitives.TopicName(value))
    override val authenticationConfiguration: Optional[
      zio.aws.firehose.model.AuthenticationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticationConfiguration())
      .map(value =>
        zio.aws.firehose.model.AuthenticationConfiguration.wrap(value)
      )
    override val deliveryStartTimestamp: Optional[DeliveryStartTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryStartTimestamp())
        .map(value =>
          zio.aws.firehose.model.primitives.DeliveryStartTimestamp(value)
        )
    override val readFromTimestamp: Optional[ReadFromTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readFromTimestamp())
        .map(value =>
          zio.aws.firehose.model.primitives.ReadFromTimestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.MSKSourceDescription
  ): zio.aws.firehose.model.MSKSourceDescription.ReadOnly = new Wrapper(impl)
}
