package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait NoEncryptionConfig {
  def unwrap: software.amazon.awssdk.services.firehose.model.NoEncryptionConfig
}
object NoEncryptionConfig {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.NoEncryptionConfig
  ): zio.aws.firehose.model.NoEncryptionConfig = value match {
    case software.amazon.awssdk.services.firehose.model.NoEncryptionConfig.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.NoEncryptionConfig.NO_ENCRYPTION =>
      val r = NoEncryption
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.NoEncryptionConfig {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.NoEncryptionConfig =
      software.amazon.awssdk.services.firehose.model.NoEncryptionConfig.UNKNOWN_TO_SDK_VERSION
  }
  case object NoEncryption extends zio.aws.firehose.model.NoEncryptionConfig {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.NoEncryptionConfig =
      software.amazon.awssdk.services.firehose.model.NoEncryptionConfig.NO_ENCRYPTION
  }
}
