package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  OrcStripeSizeBytes,
  BooleanObject,
  OrcRowIndexStride,
  NonEmptyStringWithoutWhitespace,
  BlockSizeBytes,
  Proportion
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class OrcSerDe(
    stripeSizeBytes: Optional[OrcStripeSizeBytes] = Optional.Absent,
    blockSizeBytes: Optional[BlockSizeBytes] = Optional.Absent,
    rowIndexStride: Optional[OrcRowIndexStride] = Optional.Absent,
    enablePadding: Optional[BooleanObject] = Optional.Absent,
    paddingTolerance: Optional[Proportion] = Optional.Absent,
    compression: Optional[zio.aws.firehose.model.OrcCompression] =
      Optional.Absent,
    bloomFilterColumns: Optional[Iterable[NonEmptyStringWithoutWhitespace]] =
      Optional.Absent,
    bloomFilterFalsePositiveProbability: Optional[Proportion] = Optional.Absent,
    dictionaryKeyThreshold: Optional[Proportion] = Optional.Absent,
    formatVersion: Optional[zio.aws.firehose.model.OrcFormatVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.OrcSerDe = {
    import OrcSerDe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.OrcSerDe
      .builder()
      .optionallyWith(
        stripeSizeBytes.map(value => OrcStripeSizeBytes.unwrap(value): Integer)
      )(_.stripeSizeBytes)
      .optionallyWith(
        blockSizeBytes.map(value => BlockSizeBytes.unwrap(value): Integer)
      )(_.blockSizeBytes)
      .optionallyWith(
        rowIndexStride.map(value => OrcRowIndexStride.unwrap(value): Integer)
      )(_.rowIndexStride)
      .optionallyWith(enablePadding.map(value => value: java.lang.Boolean))(
        _.enablePadding
      )
      .optionallyWith(
        paddingTolerance.map(value =>
          Proportion.unwrap(value): java.lang.Double
        )
      )(_.paddingTolerance)
      .optionallyWith(compression.map(value => value.unwrap))(_.compression)
      .optionallyWith(
        bloomFilterColumns.map(value =>
          value.map { item =>
            NonEmptyStringWithoutWhitespace.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bloomFilterColumns)
      .optionallyWith(
        bloomFilterFalsePositiveProbability.map(value =>
          Proportion.unwrap(value): java.lang.Double
        )
      )(_.bloomFilterFalsePositiveProbability)
      .optionallyWith(
        dictionaryKeyThreshold.map(value =>
          Proportion.unwrap(value): java.lang.Double
        )
      )(_.dictionaryKeyThreshold)
      .optionallyWith(formatVersion.map(value => value.unwrap))(_.formatVersion)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.OrcSerDe.ReadOnly =
    zio.aws.firehose.model.OrcSerDe.wrap(buildAwsValue())
}
object OrcSerDe {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.firehose.model.OrcSerDe] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.OrcSerDe =
      zio.aws.firehose.model.OrcSerDe(
        stripeSizeBytes.map(value => value),
        blockSizeBytes.map(value => value),
        rowIndexStride.map(value => value),
        enablePadding.map(value => value),
        paddingTolerance.map(value => value),
        compression.map(value => value),
        bloomFilterColumns.map(value => value),
        bloomFilterFalsePositiveProbability.map(value => value),
        dictionaryKeyThreshold.map(value => value),
        formatVersion.map(value => value)
      )
    def stripeSizeBytes: Optional[OrcStripeSizeBytes]
    def blockSizeBytes: Optional[BlockSizeBytes]
    def rowIndexStride: Optional[OrcRowIndexStride]
    def enablePadding: Optional[BooleanObject]
    def paddingTolerance: Optional[Proportion]
    def compression: Optional[zio.aws.firehose.model.OrcCompression]
    def bloomFilterColumns: Optional[List[NonEmptyStringWithoutWhitespace]]
    def bloomFilterFalsePositiveProbability: Optional[Proportion]
    def dictionaryKeyThreshold: Optional[Proportion]
    def formatVersion: Optional[zio.aws.firehose.model.OrcFormatVersion]
    def getStripeSizeBytes: ZIO[Any, AwsError, OrcStripeSizeBytes] =
      AwsError.unwrapOptionField("stripeSizeBytes", stripeSizeBytes)
    def getBlockSizeBytes: ZIO[Any, AwsError, BlockSizeBytes] =
      AwsError.unwrapOptionField("blockSizeBytes", blockSizeBytes)
    def getRowIndexStride: ZIO[Any, AwsError, OrcRowIndexStride] =
      AwsError.unwrapOptionField("rowIndexStride", rowIndexStride)
    def getEnablePadding: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enablePadding", enablePadding)
    def getPaddingTolerance: ZIO[Any, AwsError, Proportion] =
      AwsError.unwrapOptionField("paddingTolerance", paddingTolerance)
    def getCompression
        : ZIO[Any, AwsError, zio.aws.firehose.model.OrcCompression] =
      AwsError.unwrapOptionField("compression", compression)
    def getBloomFilterColumns
        : ZIO[Any, AwsError, List[NonEmptyStringWithoutWhitespace]] =
      AwsError.unwrapOptionField("bloomFilterColumns", bloomFilterColumns)
    def getBloomFilterFalsePositiveProbability: ZIO[Any, AwsError, Proportion] =
      AwsError.unwrapOptionField(
        "bloomFilterFalsePositiveProbability",
        bloomFilterFalsePositiveProbability
      )
    def getDictionaryKeyThreshold: ZIO[Any, AwsError, Proportion] = AwsError
      .unwrapOptionField("dictionaryKeyThreshold", dictionaryKeyThreshold)
    def getFormatVersion
        : ZIO[Any, AwsError, zio.aws.firehose.model.OrcFormatVersion] =
      AwsError.unwrapOptionField("formatVersion", formatVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.OrcSerDe
  ) extends zio.aws.firehose.model.OrcSerDe.ReadOnly {
    override val stripeSizeBytes: Optional[OrcStripeSizeBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stripeSizeBytes())
        .map(value =>
          zio.aws.firehose.model.primitives.OrcStripeSizeBytes(value)
        )
    override val blockSizeBytes: Optional[BlockSizeBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockSizeBytes())
        .map(value => zio.aws.firehose.model.primitives.BlockSizeBytes(value))
    override val rowIndexStride: Optional[OrcRowIndexStride] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rowIndexStride())
        .map(value =>
          zio.aws.firehose.model.primitives.OrcRowIndexStride(value)
        )
    override val enablePadding: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.enablePadding())
      .map(value => value: BooleanObject)
    override val paddingTolerance: Optional[Proportion] = zio.aws.core.internal
      .optionalFromNullable(impl.paddingTolerance())
      .map(value => zio.aws.firehose.model.primitives.Proportion(value))
    override val compression: Optional[zio.aws.firehose.model.OrcCompression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compression())
        .map(value => zio.aws.firehose.model.OrcCompression.wrap(value))
    override val bloomFilterColumns
        : Optional[List[NonEmptyStringWithoutWhitespace]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bloomFilterColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.firehose.model.primitives
              .NonEmptyStringWithoutWhitespace(item)
          }.toList
        )
    override val bloomFilterFalsePositiveProbability: Optional[Proportion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bloomFilterFalsePositiveProbability())
        .map(value => zio.aws.firehose.model.primitives.Proportion(value))
    override val dictionaryKeyThreshold: Optional[Proportion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dictionaryKeyThreshold())
        .map(value => zio.aws.firehose.model.primitives.Proportion(value))
    override val formatVersion
        : Optional[zio.aws.firehose.model.OrcFormatVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatVersion())
        .map(value => zio.aws.firehose.model.OrcFormatVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.OrcSerDe
  ): zio.aws.firehose.model.OrcSerDe.ReadOnly = new Wrapper(impl)
}
