package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait ParquetCompression {
  def unwrap: software.amazon.awssdk.services.firehose.model.ParquetCompression
}
object ParquetCompression {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.ParquetCompression
  ): zio.aws.firehose.model.ParquetCompression = value match {
    case software.amazon.awssdk.services.firehose.model.ParquetCompression.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.ParquetCompression.UNCOMPRESSED =>
      val r = UNCOMPRESSED
      r
    case software.amazon.awssdk.services.firehose.model.ParquetCompression.GZIP =>
      val r = GZIP
      r
    case software.amazon.awssdk.services.firehose.model.ParquetCompression.SNAPPY =>
      val r = SNAPPY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.ParquetCompression {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ParquetCompression =
      software.amazon.awssdk.services.firehose.model.ParquetCompression.UNKNOWN_TO_SDK_VERSION
  }
  case object UNCOMPRESSED extends zio.aws.firehose.model.ParquetCompression {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ParquetCompression =
      software.amazon.awssdk.services.firehose.model.ParquetCompression.UNCOMPRESSED
  }
  case object GZIP extends zio.aws.firehose.model.ParquetCompression {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ParquetCompression =
      software.amazon.awssdk.services.firehose.model.ParquetCompression.GZIP
  }
  case object SNAPPY extends zio.aws.firehose.model.ParquetCompression {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ParquetCompression =
      software.amazon.awssdk.services.firehose.model.ParquetCompression.SNAPPY
  }
}
