package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.BooleanObject
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProcessingConfiguration(
    enabled: Optional[BooleanObject] = Optional.Absent,
    processors: Optional[Iterable[zio.aws.firehose.model.Processor]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ProcessingConfiguration = {
    import ProcessingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ProcessingConfiguration
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        processors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processors)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ProcessingConfiguration.ReadOnly =
    zio.aws.firehose.model.ProcessingConfiguration.wrap(buildAwsValue())
}
object ProcessingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ProcessingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ProcessingConfiguration =
      zio.aws.firehose.model.ProcessingConfiguration(
        enabled.map(value => value),
        processors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def enabled: Optional[BooleanObject]
    def processors: Optional[List[zio.aws.firehose.model.Processor.ReadOnly]]
    def getEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getProcessors
        : ZIO[Any, AwsError, List[zio.aws.firehose.model.Processor.ReadOnly]] =
      AwsError.unwrapOptionField("processors", processors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ProcessingConfiguration
  ) extends zio.aws.firehose.model.ProcessingConfiguration.ReadOnly {
    override val enabled: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: BooleanObject)
    override val processors
        : Optional[List[zio.aws.firehose.model.Processor.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.firehose.model.Processor.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ProcessingConfiguration
  ): zio.aws.firehose.model.ProcessingConfiguration.ReadOnly = new Wrapper(impl)
}
