package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait ProcessorParameterName {
  def unwrap
      : software.amazon.awssdk.services.firehose.model.ProcessorParameterName
}
object ProcessorParameterName {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.ProcessorParameterName
  ): zio.aws.firehose.model.ProcessorParameterName = value match {
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.LAMBDA_ARN =>
      val r = LambdaArn
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.NUMBER_OF_RETRIES =>
      val r = NumberOfRetries
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.METADATA_EXTRACTION_QUERY =>
      val r = MetadataExtractionQuery
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.JSON_PARSING_ENGINE =>
      val r = JsonParsingEngine
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.ROLE_ARN =>
      val r = RoleArn
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.BUFFER_SIZE_IN_M_BS =>
      val r = BufferSizeInMBs
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.BUFFER_INTERVAL_IN_SECONDS =>
      val r = BufferIntervalInSeconds
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.SUB_RECORD_TYPE =>
      val r = SubRecordType
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.DELIMITER =>
      val r = Delimiter
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.COMPRESSION_FORMAT =>
      val r = CompressionFormat
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorParameterName.DATA_MESSAGE_EXTRACTION =>
      val r = DataMessageExtraction
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.UNKNOWN_TO_SDK_VERSION
  }
  case object LambdaArn extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.LAMBDA_ARN
  }
  case object NumberOfRetries
      extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.NUMBER_OF_RETRIES
  }
  case object MetadataExtractionQuery
      extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.METADATA_EXTRACTION_QUERY
  }
  case object JsonParsingEngine
      extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.JSON_PARSING_ENGINE
  }
  case object RoleArn extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.ROLE_ARN
  }
  case object BufferSizeInMBs
      extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.BUFFER_SIZE_IN_M_BS
  }
  case object BufferIntervalInSeconds
      extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.BUFFER_INTERVAL_IN_SECONDS
  }
  case object SubRecordType
      extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.SUB_RECORD_TYPE
  }
  case object Delimiter extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.DELIMITER
  }
  case object CompressionFormat
      extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.COMPRESSION_FORMAT
  }
  case object DataMessageExtraction
      extends zio.aws.firehose.model.ProcessorParameterName {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorParameterName =
      software.amazon.awssdk.services.firehose.model.ProcessorParameterName.DATA_MESSAGE_EXTRACTION
  }
}
