package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait ProcessorType {
  def unwrap: software.amazon.awssdk.services.firehose.model.ProcessorType
}
object ProcessorType {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.ProcessorType
  ): zio.aws.firehose.model.ProcessorType = value match {
    case software.amazon.awssdk.services.firehose.model.ProcessorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorType.RECORD_DE_AGGREGATION =>
      val r = RecordDeAggregation
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorType.DECOMPRESSION =>
      val r = Decompression
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorType.CLOUD_WATCH_LOG_PROCESSING =>
      val r = CloudWatchLogProcessing
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorType.LAMBDA =>
      val r = Lambda
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorType.METADATA_EXTRACTION =>
      val r = MetadataExtraction
      r
    case software.amazon.awssdk.services.firehose.model.ProcessorType.APPEND_DELIMITER_TO_RECORD =>
      val r = AppendDelimiterToRecord
      r
  }
  case object unknownToSdkVersion extends zio.aws.firehose.model.ProcessorType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorType =
      software.amazon.awssdk.services.firehose.model.ProcessorType.UNKNOWN_TO_SDK_VERSION
  }
  case object RecordDeAggregation extends zio.aws.firehose.model.ProcessorType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorType =
      software.amazon.awssdk.services.firehose.model.ProcessorType.RECORD_DE_AGGREGATION
  }
  case object Decompression extends zio.aws.firehose.model.ProcessorType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorType =
      software.amazon.awssdk.services.firehose.model.ProcessorType.DECOMPRESSION
  }
  case object CloudWatchLogProcessing
      extends zio.aws.firehose.model.ProcessorType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorType =
      software.amazon.awssdk.services.firehose.model.ProcessorType.CLOUD_WATCH_LOG_PROCESSING
  }
  case object Lambda extends zio.aws.firehose.model.ProcessorType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorType =
      software.amazon.awssdk.services.firehose.model.ProcessorType.LAMBDA
  }
  case object MetadataExtraction extends zio.aws.firehose.model.ProcessorType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorType =
      software.amazon.awssdk.services.firehose.model.ProcessorType.METADATA_EXTRACTION
  }
  case object AppendDelimiterToRecord
      extends zio.aws.firehose.model.ProcessorType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ProcessorType =
      software.amazon.awssdk.services.firehose.model.ProcessorType.APPEND_DELIMITER_TO_RECORD
  }
}
