package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.DeliveryStreamName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutRecordBatchRequest(
    deliveryStreamName: DeliveryStreamName,
    records: Iterable[zio.aws.firehose.model.Record]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest = {
    import PutRecordBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .records(records.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.PutRecordBatchRequest.ReadOnly =
    zio.aws.firehose.model.PutRecordBatchRequest.wrap(buildAwsValue())
}
object PutRecordBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.PutRecordBatchRequest =
      zio.aws.firehose.model.PutRecordBatchRequest(
        deliveryStreamName,
        records.map { item =>
          item.asEditable
        }
      )
    def deliveryStreamName: DeliveryStreamName
    def records: List[zio.aws.firehose.model.Record.ReadOnly]
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getRecords
        : ZIO[Any, Nothing, List[zio.aws.firehose.model.Record.ReadOnly]] =
      ZIO.succeed(records)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest
  ) extends zio.aws.firehose.model.PutRecordBatchRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val records: List[zio.aws.firehose.model.Record.ReadOnly] = impl
      .records()
      .asScala
      .map { item =>
        zio.aws.firehose.model.Record.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest
  ): zio.aws.firehose.model.PutRecordBatchRequest.ReadOnly = new Wrapper(impl)
}
