package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.DeliveryStreamName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutRecordRequest(
    deliveryStreamName: DeliveryStreamName,
    record: zio.aws.firehose.model.Record
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.PutRecordRequest = {
    import PutRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.PutRecordRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .record(record.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.PutRecordRequest.ReadOnly =
    zio.aws.firehose.model.PutRecordRequest.wrap(buildAwsValue())
}
object PutRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.PutRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.PutRecordRequest =
      zio.aws.firehose.model
        .PutRecordRequest(deliveryStreamName, record.asEditable)
    def deliveryStreamName: DeliveryStreamName
    def record: zio.aws.firehose.model.Record.ReadOnly
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getRecord: ZIO[Any, Nothing, zio.aws.firehose.model.Record.ReadOnly] =
      ZIO.succeed(record)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordRequest
  ) extends zio.aws.firehose.model.PutRecordRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val record: zio.aws.firehose.model.Record.ReadOnly =
      zio.aws.firehose.model.Record.wrap(impl.record())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.PutRecordRequest
  ): zio.aws.firehose.model.PutRecordRequest.ReadOnly = new Wrapper(impl)
}
