package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.Data
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Record(data: Data) {
  def buildAwsValue(): software.amazon.awssdk.services.firehose.model.Record = {
    import Record.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.Record
      .builder()
      .data(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(data.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.Record.ReadOnly =
    zio.aws.firehose.model.Record.wrap(buildAwsValue())
}
object Record {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.firehose.model.Record] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.Record =
      zio.aws.firehose.model.Record(data)
    def data: Data
    def getData: ZIO[Any, Nothing, Data] = ZIO.succeed(data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.Record
  ) extends zio.aws.firehose.model.Record.ReadOnly {
    override val data: Data = zio.aws.firehose.model.primitives
      .Data(zio.Chunk.fromArray(impl.data().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.Record
  ): zio.aws.firehose.model.Record.ReadOnly = new Wrapper(impl)
}
