package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  Password,
  Username,
  ClusterJDBCURL,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RedshiftDestinationUpdate(
    roleARN: Optional[RoleARN] = Optional.Absent,
    clusterJDBCURL: Optional[ClusterJDBCURL] = Optional.Absent,
    copyCommand: Optional[zio.aws.firehose.model.CopyCommand] = Optional.Absent,
    username: Optional[Username] = Optional.Absent,
    password: Optional[Password] = Optional.Absent,
    retryOptions: Optional[zio.aws.firehose.model.RedshiftRetryOptions] =
      Optional.Absent,
    s3Update: Optional[zio.aws.firehose.model.S3DestinationUpdate] =
      Optional.Absent,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.RedshiftS3BackupMode] =
      Optional.Absent,
    s3BackupUpdate: Optional[zio.aws.firehose.model.S3DestinationUpdate] =
      Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    secretsManagerConfiguration: Optional[
      zio.aws.firehose.model.SecretsManagerConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate = {
    import RedshiftDestinationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate
      .builder()
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        clusterJDBCURL.map(value =>
          ClusterJDBCURL.unwrap(value): java.lang.String
        )
      )(_.clusterJDBCURL)
      .optionallyWith(copyCommand.map(value => value.buildAwsValue()))(
        _.copyCommand
      )
      .optionallyWith(
        username.map(value => Username.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(
        password.map(value => Password.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3Update.map(value => value.buildAwsValue()))(_.s3Update)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(s3BackupUpdate.map(value => value.buildAwsValue()))(
        _.s3BackupUpdate
      )
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        secretsManagerConfiguration.map(value => value.buildAwsValue())
      )(_.secretsManagerConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.RedshiftDestinationUpdate.ReadOnly =
    zio.aws.firehose.model.RedshiftDestinationUpdate.wrap(buildAwsValue())
}
object RedshiftDestinationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.RedshiftDestinationUpdate =
      zio.aws.firehose.model.RedshiftDestinationUpdate(
        roleARN.map(value => value),
        clusterJDBCURL.map(value => value),
        copyCommand.map(value => value.asEditable),
        username.map(value => value),
        password.map(value => value),
        retryOptions.map(value => value.asEditable),
        s3Update.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3BackupUpdate.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        secretsManagerConfiguration.map(value => value.asEditable)
      )
    def roleARN: Optional[RoleARN]
    def clusterJDBCURL: Optional[ClusterJDBCURL]
    def copyCommand: Optional[zio.aws.firehose.model.CopyCommand.ReadOnly]
    def username: Optional[Username]
    def password: Optional[Password]
    def retryOptions
        : Optional[zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly]
    def s3Update: Optional[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly]
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.RedshiftS3BackupMode]
    def s3BackupUpdate
        : Optional[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def secretsManagerConfiguration
        : Optional[zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly]
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getClusterJDBCURL: ZIO[Any, AwsError, ClusterJDBCURL] =
      AwsError.unwrapOptionField("clusterJDBCURL", clusterJDBCURL)
    def getCopyCommand
        : ZIO[Any, AwsError, zio.aws.firehose.model.CopyCommand.ReadOnly] =
      AwsError.unwrapOptionField("copyCommand", copyCommand)
    def getUsername: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, Password] =
      AwsError.unwrapOptionField("password", password)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3Update: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3Update", s3Update)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.RedshiftS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3BackupUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3BackupUpdate", s3BackupUpdate)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getSecretsManagerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "secretsManagerConfiguration",
      secretsManagerConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate
  ) extends zio.aws.firehose.model.RedshiftDestinationUpdate.ReadOnly {
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val clusterJDBCURL: Optional[ClusterJDBCURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterJDBCURL())
        .map(value => zio.aws.firehose.model.primitives.ClusterJDBCURL(value))
    override val copyCommand
        : Optional[zio.aws.firehose.model.CopyCommand.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyCommand())
        .map(value => zio.aws.firehose.model.CopyCommand.wrap(value))
    override val username: Optional[Username] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.firehose.model.primitives.Username(value))
    override val password: Optional[Password] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.firehose.model.primitives.Password(value))
    override val retryOptions
        : Optional[zio.aws.firehose.model.RedshiftRetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value => zio.aws.firehose.model.RedshiftRetryOptions.wrap(value))
    override val s3Update
        : Optional[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Update())
        .map(value => zio.aws.firehose.model.S3DestinationUpdate.wrap(value))
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.RedshiftS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.RedshiftS3BackupMode.wrap(value))
    override val s3BackupUpdate
        : Optional[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupUpdate())
        .map(value => zio.aws.firehose.model.S3DestinationUpdate.wrap(value))
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val secretsManagerConfiguration: Optional[
      zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secretsManagerConfiguration())
      .map(value =>
        zio.aws.firehose.model.SecretsManagerConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate
  ): zio.aws.firehose.model.RedshiftDestinationUpdate.ReadOnly = new Wrapper(
    impl
  )
}
