package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait RedshiftS3BackupMode {
  def unwrap
      : software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode
}
object RedshiftS3BackupMode {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode
  ): zio.aws.firehose.model.RedshiftS3BackupMode = value match {
    case software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode.DISABLED =>
      val r = Disabled
      r
    case software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode.ENABLED =>
      val r = Enabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.RedshiftS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode =
      software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Disabled extends zio.aws.firehose.model.RedshiftS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode =
      software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode.DISABLED
  }
  case object Enabled extends zio.aws.firehose.model.RedshiftS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode =
      software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode.ENABLED
  }
}
