package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.RetryDurationInSeconds
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RetryOptions(
    durationInSeconds: Optional[RetryDurationInSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.RetryOptions = {
    import RetryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.RetryOptions
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          RetryDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.RetryOptions.ReadOnly =
    zio.aws.firehose.model.RetryOptions.wrap(buildAwsValue())
}
object RetryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.RetryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.RetryOptions =
      zio.aws.firehose.model.RetryOptions(durationInSeconds.map(value => value))
    def durationInSeconds: Optional[RetryDurationInSeconds]
    def getDurationInSeconds: ZIO[Any, AwsError, RetryDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.RetryOptions
  ) extends zio.aws.firehose.model.RetryOptions.ReadOnly {
    override val durationInSeconds: Optional[RetryDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives.RetryDurationInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.RetryOptions
  ): zio.aws.firehose.model.RetryOptions.ReadOnly = new Wrapper(impl)
}
