package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  ErrorOutputPrefix,
  Prefix,
  BucketARN,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3DestinationDescription(
    roleARN: RoleARN,
    bucketARN: BucketARN,
    prefix: Optional[Prefix] = Optional.Absent,
    errorOutputPrefix: Optional[ErrorOutputPrefix] = Optional.Absent,
    bufferingHints: zio.aws.firehose.model.BufferingHints,
    compressionFormat: zio.aws.firehose.model.CompressionFormat,
    encryptionConfiguration: zio.aws.firehose.model.EncryptionConfiguration,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.S3DestinationDescription = {
    import S3DestinationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.S3DestinationDescription
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        errorOutputPrefix.map(value =>
          ErrorOutputPrefix.unwrap(value): java.lang.String
        )
      )(_.errorOutputPrefix)
      .bufferingHints(bufferingHints.buildAwsValue())
      .compressionFormat(compressionFormat.unwrap)
      .encryptionConfiguration(encryptionConfiguration.buildAwsValue())
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.S3DestinationDescription.ReadOnly =
    zio.aws.firehose.model.S3DestinationDescription.wrap(buildAwsValue())
}
object S3DestinationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.S3DestinationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.S3DestinationDescription =
      zio.aws.firehose.model.S3DestinationDescription(
        roleARN,
        bucketARN,
        prefix.map(value => value),
        errorOutputPrefix.map(value => value),
        bufferingHints.asEditable,
        compressionFormat,
        encryptionConfiguration.asEditable,
        cloudWatchLoggingOptions.map(value => value.asEditable)
      )
    def roleARN: RoleARN
    def bucketARN: BucketARN
    def prefix: Optional[Prefix]
    def errorOutputPrefix: Optional[ErrorOutputPrefix]
    def bufferingHints: zio.aws.firehose.model.BufferingHints.ReadOnly
    def compressionFormat: zio.aws.firehose.model.CompressionFormat
    def encryptionConfiguration
        : zio.aws.firehose.model.EncryptionConfiguration.ReadOnly
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getErrorOutputPrefix: ZIO[Any, AwsError, ErrorOutputPrefix] =
      AwsError.unwrapOptionField("errorOutputPrefix", errorOutputPrefix)
    def getBufferingHints
        : ZIO[Any, Nothing, zio.aws.firehose.model.BufferingHints.ReadOnly] =
      ZIO.succeed(bufferingHints)
    def getCompressionFormat
        : ZIO[Any, Nothing, zio.aws.firehose.model.CompressionFormat] =
      ZIO.succeed(compressionFormat)
    def getEncryptionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.EncryptionConfiguration.ReadOnly
    ] = ZIO.succeed(encryptionConfiguration)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.S3DestinationDescription
  ) extends zio.aws.firehose.model.S3DestinationDescription.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val bucketARN: BucketARN =
      zio.aws.firehose.model.primitives.BucketARN(impl.bucketARN())
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.firehose.model.primitives.Prefix(value))
    override val errorOutputPrefix: Optional[ErrorOutputPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorOutputPrefix())
        .map(value =>
          zio.aws.firehose.model.primitives.ErrorOutputPrefix(value)
        )
    override val bufferingHints
        : zio.aws.firehose.model.BufferingHints.ReadOnly =
      zio.aws.firehose.model.BufferingHints.wrap(impl.bufferingHints())
    override val compressionFormat: zio.aws.firehose.model.CompressionFormat =
      zio.aws.firehose.model.CompressionFormat.wrap(impl.compressionFormat())
    override val encryptionConfiguration
        : zio.aws.firehose.model.EncryptionConfiguration.ReadOnly =
      zio.aws.firehose.model.EncryptionConfiguration
        .wrap(impl.encryptionConfiguration())
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.S3DestinationDescription
  ): zio.aws.firehose.model.S3DestinationDescription.ReadOnly = new Wrapper(
    impl
  )
}
