package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  ErrorOutputPrefix,
  Prefix,
  BucketARN,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3DestinationUpdate(
    roleARN: Optional[RoleARN] = Optional.Absent,
    bucketARN: Optional[BucketARN] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    errorOutputPrefix: Optional[ErrorOutputPrefix] = Optional.Absent,
    bufferingHints: Optional[zio.aws.firehose.model.BufferingHints] =
      Optional.Absent,
    compressionFormat: Optional[zio.aws.firehose.model.CompressionFormat] =
      Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.firehose.model.EncryptionConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.S3DestinationUpdate = {
    import S3DestinationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.S3DestinationUpdate
      .builder()
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        bucketARN.map(value => BucketARN.unwrap(value): java.lang.String)
      )(_.bucketARN)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        errorOutputPrefix.map(value =>
          ErrorOutputPrefix.unwrap(value): java.lang.String
        )
      )(_.errorOutputPrefix)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(compressionFormat.map(value => value.unwrap))(
        _.compressionFormat
      )
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.S3DestinationUpdate.ReadOnly =
    zio.aws.firehose.model.S3DestinationUpdate.wrap(buildAwsValue())
}
object S3DestinationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.S3DestinationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.S3DestinationUpdate =
      zio.aws.firehose.model.S3DestinationUpdate(
        roleARN.map(value => value),
        bucketARN.map(value => value),
        prefix.map(value => value),
        errorOutputPrefix.map(value => value),
        bufferingHints.map(value => value.asEditable),
        compressionFormat.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable)
      )
    def roleARN: Optional[RoleARN]
    def bucketARN: Optional[BucketARN]
    def prefix: Optional[Prefix]
    def errorOutputPrefix: Optional[ErrorOutputPrefix]
    def bufferingHints: Optional[zio.aws.firehose.model.BufferingHints.ReadOnly]
    def compressionFormat: Optional[zio.aws.firehose.model.CompressionFormat]
    def encryptionConfiguration
        : Optional[zio.aws.firehose.model.EncryptionConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getBucketARN: ZIO[Any, AwsError, BucketARN] =
      AwsError.unwrapOptionField("bucketARN", bucketARN)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getErrorOutputPrefix: ZIO[Any, AwsError, ErrorOutputPrefix] =
      AwsError.unwrapOptionField("errorOutputPrefix", errorOutputPrefix)
    def getBufferingHints
        : ZIO[Any, AwsError, zio.aws.firehose.model.BufferingHints.ReadOnly] =
      AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getCompressionFormat
        : ZIO[Any, AwsError, zio.aws.firehose.model.CompressionFormat] =
      AwsError.unwrapOptionField("compressionFormat", compressionFormat)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.S3DestinationUpdate
  ) extends zio.aws.firehose.model.S3DestinationUpdate.ReadOnly {
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val bucketARN: Optional[BucketARN] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketARN())
      .map(value => zio.aws.firehose.model.primitives.BucketARN(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.firehose.model.primitives.Prefix(value))
    override val errorOutputPrefix: Optional[ErrorOutputPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorOutputPrefix())
        .map(value =>
          zio.aws.firehose.model.primitives.ErrorOutputPrefix(value)
        )
    override val bufferingHints
        : Optional[zio.aws.firehose.model.BufferingHints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bufferingHints())
        .map(value => zio.aws.firehose.model.BufferingHints.wrap(value))
    override val compressionFormat
        : Optional[zio.aws.firehose.model.CompressionFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compressionFormat())
        .map(value => zio.aws.firehose.model.CompressionFormat.wrap(value))
    override val encryptionConfiguration
        : Optional[zio.aws.firehose.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value =>
          zio.aws.firehose.model.EncryptionConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.S3DestinationUpdate
  ): zio.aws.firehose.model.S3DestinationUpdate.ReadOnly = new Wrapper(impl)
}
