package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{BooleanObject, RoleARN, SecretARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecretsManagerConfiguration(
    secretARN: Optional[SecretARN] = Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent,
    enabled: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SecretsManagerConfiguration = {
    import SecretsManagerConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SecretsManagerConfiguration
      .builder()
      .optionallyWith(
        secretARN.map(value => SecretARN.unwrap(value): java.lang.String)
      )(_.secretARN)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly =
    zio.aws.firehose.model.SecretsManagerConfiguration.wrap(buildAwsValue())
}
object SecretsManagerConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SecretsManagerConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SecretsManagerConfiguration =
      zio.aws.firehose.model.SecretsManagerConfiguration(
        secretARN.map(value => value),
        roleARN.map(value => value),
        enabled
      )
    def secretARN: Optional[SecretARN]
    def roleARN: Optional[RoleARN]
    def enabled: BooleanObject
    def getSecretARN: ZIO[Any, AwsError, SecretARN] =
      AwsError.unwrapOptionField("secretARN", secretARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getEnabled: ZIO[Any, Nothing, BooleanObject] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SecretsManagerConfiguration
  ) extends zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly {
    override val secretARN: Optional[SecretARN] = zio.aws.core.internal
      .optionalFromNullable(impl.secretARN())
      .map(value => zio.aws.firehose.model.primitives.SecretARN(value))
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val enabled: BooleanObject = impl.enabled(): BooleanObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SecretsManagerConfiguration
  ): zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
