package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  SnowflakeBufferingIntervalInSeconds,
  SnowflakeBufferingSizeInMBs
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SnowflakeBufferingHints(
    sizeInMBs: Optional[SnowflakeBufferingSizeInMBs] = Optional.Absent,
    intervalInSeconds: Optional[SnowflakeBufferingIntervalInSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SnowflakeBufferingHints = {
    import SnowflakeBufferingHints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SnowflakeBufferingHints
      .builder()
      .optionallyWith(
        sizeInMBs.map(value =>
          SnowflakeBufferingSizeInMBs.unwrap(value): Integer
        )
      )(_.sizeInMBs)
      .optionallyWith(
        intervalInSeconds.map(value =>
          SnowflakeBufferingIntervalInSeconds.unwrap(value): Integer
        )
      )(_.intervalInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SnowflakeBufferingHints.ReadOnly =
    zio.aws.firehose.model.SnowflakeBufferingHints.wrap(buildAwsValue())
}
object SnowflakeBufferingHints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SnowflakeBufferingHints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SnowflakeBufferingHints =
      zio.aws.firehose.model.SnowflakeBufferingHints(
        sizeInMBs.map(value => value),
        intervalInSeconds.map(value => value)
      )
    def sizeInMBs: Optional[SnowflakeBufferingSizeInMBs]
    def intervalInSeconds: Optional[SnowflakeBufferingIntervalInSeconds]
    def getSizeInMBs: ZIO[Any, AwsError, SnowflakeBufferingSizeInMBs] =
      AwsError.unwrapOptionField("sizeInMBs", sizeInMBs)
    def getIntervalInSeconds
        : ZIO[Any, AwsError, SnowflakeBufferingIntervalInSeconds] =
      AwsError.unwrapOptionField("intervalInSeconds", intervalInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeBufferingHints
  ) extends zio.aws.firehose.model.SnowflakeBufferingHints.ReadOnly {
    override val sizeInMBs: Optional[SnowflakeBufferingSizeInMBs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeInMBs())
        .map(value =>
          zio.aws.firehose.model.primitives.SnowflakeBufferingSizeInMBs(value)
        )
    override val intervalInSeconds
        : Optional[SnowflakeBufferingIntervalInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.intervalInSeconds())
      .map(value =>
        zio.aws.firehose.model.primitives
          .SnowflakeBufferingIntervalInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeBufferingHints
  ): zio.aws.firehose.model.SnowflakeBufferingHints.ReadOnly = new Wrapper(impl)
}
