package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait SnowflakeDataLoadingOption {
  def unwrap: software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption
}
object SnowflakeDataLoadingOption {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption
  ): zio.aws.firehose.model.SnowflakeDataLoadingOption = value match {
    case software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption.JSON_MAPPING =>
      val r = JSON_MAPPING
      r
    case software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption.VARIANT_CONTENT_MAPPING =>
      val r = VARIANT_CONTENT_MAPPING
      r
    case software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption.VARIANT_CONTENT_AND_METADATA_MAPPING =>
      val r = VARIANT_CONTENT_AND_METADATA_MAPPING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.SnowflakeDataLoadingOption {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption =
      software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON_MAPPING
      extends zio.aws.firehose.model.SnowflakeDataLoadingOption {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption =
      software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption.JSON_MAPPING
  }
  case object VARIANT_CONTENT_MAPPING
      extends zio.aws.firehose.model.SnowflakeDataLoadingOption {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption =
      software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption.VARIANT_CONTENT_MAPPING
  }
  case object VARIANT_CONTENT_AND_METADATA_MAPPING
      extends zio.aws.firehose.model.SnowflakeDataLoadingOption {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption =
      software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption.VARIANT_CONTENT_AND_METADATA_MAPPING
  }
}
