package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  SnowflakePrivateKey,
  SnowflakeAccountUrl,
  SnowflakeUser,
  SnowflakeMetaDataColumnName,
  SnowflakeDatabase,
  SnowflakeSchema,
  RoleARN,
  SnowflakeContentColumnName,
  SnowflakeKeyPassphrase,
  SnowflakeTable
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnowflakeDestinationConfiguration(
    accountUrl: SnowflakeAccountUrl,
    privateKey: Optional[SnowflakePrivateKey] = Optional.Absent,
    keyPassphrase: Optional[SnowflakeKeyPassphrase] = Optional.Absent,
    user: Optional[SnowflakeUser] = Optional.Absent,
    database: SnowflakeDatabase,
    schema: SnowflakeSchema,
    table: SnowflakeTable,
    snowflakeRoleConfiguration: Optional[
      zio.aws.firehose.model.SnowflakeRoleConfiguration
    ] = Optional.Absent,
    dataLoadingOption: Optional[
      zio.aws.firehose.model.SnowflakeDataLoadingOption
    ] = Optional.Absent,
    metaDataColumnName: Optional[SnowflakeMetaDataColumnName] = Optional.Absent,
    contentColumnName: Optional[SnowflakeContentColumnName] = Optional.Absent,
    snowflakeVpcConfiguration: Optional[
      zio.aws.firehose.model.SnowflakeVpcConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    roleARN: RoleARN,
    retryOptions: Optional[zio.aws.firehose.model.SnowflakeRetryOptions] =
      Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.SnowflakeS3BackupMode] =
      Optional.Absent,
    s3Configuration: zio.aws.firehose.model.S3DestinationConfiguration,
    secretsManagerConfiguration: Optional[
      zio.aws.firehose.model.SecretsManagerConfiguration
    ] = Optional.Absent,
    bufferingHints: Optional[zio.aws.firehose.model.SnowflakeBufferingHints] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SnowflakeDestinationConfiguration = {
    import SnowflakeDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SnowflakeDestinationConfiguration
      .builder()
      .accountUrl(SnowflakeAccountUrl.unwrap(accountUrl): java.lang.String)
      .optionallyWith(
        privateKey.map(value =>
          SnowflakePrivateKey.unwrap(value): java.lang.String
        )
      )(_.privateKey)
      .optionallyWith(
        keyPassphrase.map(value =>
          SnowflakeKeyPassphrase.unwrap(value): java.lang.String
        )
      )(_.keyPassphrase)
      .optionallyWith(
        user.map(value => SnowflakeUser.unwrap(value): java.lang.String)
      )(_.user)
      .database(SnowflakeDatabase.unwrap(database): java.lang.String)
      .schema(SnowflakeSchema.unwrap(schema): java.lang.String)
      .table(SnowflakeTable.unwrap(table): java.lang.String)
      .optionallyWith(
        snowflakeRoleConfiguration.map(value => value.buildAwsValue())
      )(_.snowflakeRoleConfiguration)
      .optionallyWith(dataLoadingOption.map(value => value.unwrap))(
        _.dataLoadingOption
      )
      .optionallyWith(
        metaDataColumnName.map(value =>
          SnowflakeMetaDataColumnName.unwrap(value): java.lang.String
        )
      )(_.metaDataColumnName)
      .optionallyWith(
        contentColumnName.map(value =>
          SnowflakeContentColumnName.unwrap(value): java.lang.String
        )
      )(_.contentColumnName)
      .optionallyWith(
        snowflakeVpcConfiguration.map(value => value.buildAwsValue())
      )(_.snowflakeVpcConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .s3Configuration(s3Configuration.buildAwsValue())
      .optionallyWith(
        secretsManagerConfiguration.map(value => value.buildAwsValue())
      )(_.secretsManagerConfiguration)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.SnowflakeDestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.SnowflakeDestinationConfiguration
      .wrap(buildAwsValue())
}
object SnowflakeDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SnowflakeDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SnowflakeDestinationConfiguration =
      zio.aws.firehose.model.SnowflakeDestinationConfiguration(
        accountUrl,
        privateKey.map(value => value),
        keyPassphrase.map(value => value),
        user.map(value => value),
        database,
        schema,
        table,
        snowflakeRoleConfiguration.map(value => value.asEditable),
        dataLoadingOption.map(value => value),
        metaDataColumnName.map(value => value),
        contentColumnName.map(value => value),
        snowflakeVpcConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        roleARN,
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3Configuration.asEditable,
        secretsManagerConfiguration.map(value => value.asEditable),
        bufferingHints.map(value => value.asEditable)
      )
    def accountUrl: SnowflakeAccountUrl
    def privateKey: Optional[SnowflakePrivateKey]
    def keyPassphrase: Optional[SnowflakeKeyPassphrase]
    def user: Optional[SnowflakeUser]
    def database: SnowflakeDatabase
    def schema: SnowflakeSchema
    def table: SnowflakeTable
    def snowflakeRoleConfiguration
        : Optional[zio.aws.firehose.model.SnowflakeRoleConfiguration.ReadOnly]
    def dataLoadingOption
        : Optional[zio.aws.firehose.model.SnowflakeDataLoadingOption]
    def metaDataColumnName: Optional[SnowflakeMetaDataColumnName]
    def contentColumnName: Optional[SnowflakeContentColumnName]
    def snowflakeVpcConfiguration
        : Optional[zio.aws.firehose.model.SnowflakeVpcConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def roleARN: RoleARN
    def retryOptions
        : Optional[zio.aws.firehose.model.SnowflakeRetryOptions.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.SnowflakeS3BackupMode]
    def s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    def secretsManagerConfiguration
        : Optional[zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly]
    def bufferingHints
        : Optional[zio.aws.firehose.model.SnowflakeBufferingHints.ReadOnly]
    def getAccountUrl: ZIO[Any, Nothing, SnowflakeAccountUrl] =
      ZIO.succeed(accountUrl)
    def getPrivateKey: ZIO[Any, AwsError, SnowflakePrivateKey] =
      AwsError.unwrapOptionField("privateKey", privateKey)
    def getKeyPassphrase: ZIO[Any, AwsError, SnowflakeKeyPassphrase] =
      AwsError.unwrapOptionField("keyPassphrase", keyPassphrase)
    def getUser: ZIO[Any, AwsError, SnowflakeUser] =
      AwsError.unwrapOptionField("user", user)
    def getDatabase: ZIO[Any, Nothing, SnowflakeDatabase] =
      ZIO.succeed(database)
    def getSchema: ZIO[Any, Nothing, SnowflakeSchema] = ZIO.succeed(schema)
    def getTable: ZIO[Any, Nothing, SnowflakeTable] = ZIO.succeed(table)
    def getSnowflakeRoleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SnowflakeRoleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "snowflakeRoleConfiguration",
      snowflakeRoleConfiguration
    )
    def getDataLoadingOption: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SnowflakeDataLoadingOption
    ] = AwsError.unwrapOptionField("dataLoadingOption", dataLoadingOption)
    def getMetaDataColumnName: ZIO[Any, AwsError, SnowflakeMetaDataColumnName] =
      AwsError.unwrapOptionField("metaDataColumnName", metaDataColumnName)
    def getContentColumnName: ZIO[Any, AwsError, SnowflakeContentColumnName] =
      AwsError.unwrapOptionField("contentColumnName", contentColumnName)
    def getSnowflakeVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SnowflakeVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "snowflakeVpcConfiguration",
      snowflakeVpcConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SnowflakeRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.SnowflakeS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
    def getSecretsManagerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "secretsManagerConfiguration",
      secretsManagerConfiguration
    )
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SnowflakeBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeDestinationConfiguration
  ) extends zio.aws.firehose.model.SnowflakeDestinationConfiguration.ReadOnly {
    override val accountUrl: SnowflakeAccountUrl =
      zio.aws.firehose.model.primitives.SnowflakeAccountUrl(impl.accountUrl())
    override val privateKey: Optional[SnowflakePrivateKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateKey())
        .map(value =>
          zio.aws.firehose.model.primitives.SnowflakePrivateKey(value)
        )
    override val keyPassphrase: Optional[SnowflakeKeyPassphrase] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPassphrase())
        .map(value =>
          zio.aws.firehose.model.primitives.SnowflakeKeyPassphrase(value)
        )
    override val user: Optional[SnowflakeUser] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => zio.aws.firehose.model.primitives.SnowflakeUser(value))
    override val database: SnowflakeDatabase =
      zio.aws.firehose.model.primitives.SnowflakeDatabase(impl.database())
    override val schema: SnowflakeSchema =
      zio.aws.firehose.model.primitives.SnowflakeSchema(impl.schema())
    override val table: SnowflakeTable =
      zio.aws.firehose.model.primitives.SnowflakeTable(impl.table())
    override val snowflakeRoleConfiguration
        : Optional[zio.aws.firehose.model.SnowflakeRoleConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snowflakeRoleConfiguration())
        .map(value =>
          zio.aws.firehose.model.SnowflakeRoleConfiguration.wrap(value)
        )
    override val dataLoadingOption
        : Optional[zio.aws.firehose.model.SnowflakeDataLoadingOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataLoadingOption())
        .map(value =>
          zio.aws.firehose.model.SnowflakeDataLoadingOption.wrap(value)
        )
    override val metaDataColumnName: Optional[SnowflakeMetaDataColumnName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metaDataColumnName())
        .map(value =>
          zio.aws.firehose.model.primitives.SnowflakeMetaDataColumnName(value)
        )
    override val contentColumnName: Optional[SnowflakeContentColumnName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentColumnName())
        .map(value =>
          zio.aws.firehose.model.primitives.SnowflakeContentColumnName(value)
        )
    override val snowflakeVpcConfiguration
        : Optional[zio.aws.firehose.model.SnowflakeVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snowflakeVpcConfiguration())
        .map(value =>
          zio.aws.firehose.model.SnowflakeVpcConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val retryOptions
        : Optional[zio.aws.firehose.model.SnowflakeRetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value => zio.aws.firehose.model.SnowflakeRetryOptions.wrap(value))
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.SnowflakeS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.SnowflakeS3BackupMode.wrap(value))
    override val s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
      zio.aws.firehose.model.S3DestinationConfiguration
        .wrap(impl.s3Configuration())
    override val secretsManagerConfiguration: Optional[
      zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secretsManagerConfiguration())
      .map(value =>
        zio.aws.firehose.model.SecretsManagerConfiguration.wrap(value)
      )
    override val bufferingHints
        : Optional[zio.aws.firehose.model.SnowflakeBufferingHints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bufferingHints())
        .map(value =>
          zio.aws.firehose.model.SnowflakeBufferingHints.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeDestinationConfiguration
  ): zio.aws.firehose.model.SnowflakeDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
