package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  SnowflakePrivateKey,
  SnowflakeAccountUrl,
  SnowflakeUser,
  SnowflakeMetaDataColumnName,
  SnowflakeDatabase,
  SnowflakeSchema,
  RoleARN,
  SnowflakeContentColumnName,
  SnowflakeKeyPassphrase,
  SnowflakeTable
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnowflakeDestinationUpdate(
    accountUrl: Optional[SnowflakeAccountUrl] = Optional.Absent,
    privateKey: Optional[SnowflakePrivateKey] = Optional.Absent,
    keyPassphrase: Optional[SnowflakeKeyPassphrase] = Optional.Absent,
    user: Optional[SnowflakeUser] = Optional.Absent,
    database: Optional[SnowflakeDatabase] = Optional.Absent,
    schema: Optional[SnowflakeSchema] = Optional.Absent,
    table: Optional[SnowflakeTable] = Optional.Absent,
    snowflakeRoleConfiguration: Optional[
      zio.aws.firehose.model.SnowflakeRoleConfiguration
    ] = Optional.Absent,
    dataLoadingOption: Optional[
      zio.aws.firehose.model.SnowflakeDataLoadingOption
    ] = Optional.Absent,
    metaDataColumnName: Optional[SnowflakeMetaDataColumnName] = Optional.Absent,
    contentColumnName: Optional[SnowflakeContentColumnName] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent,
    retryOptions: Optional[zio.aws.firehose.model.SnowflakeRetryOptions] =
      Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.SnowflakeS3BackupMode] =
      Optional.Absent,
    s3Update: Optional[zio.aws.firehose.model.S3DestinationUpdate] =
      Optional.Absent,
    secretsManagerConfiguration: Optional[
      zio.aws.firehose.model.SecretsManagerConfiguration
    ] = Optional.Absent,
    bufferingHints: Optional[zio.aws.firehose.model.SnowflakeBufferingHints] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SnowflakeDestinationUpdate = {
    import SnowflakeDestinationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SnowflakeDestinationUpdate
      .builder()
      .optionallyWith(
        accountUrl.map(value =>
          SnowflakeAccountUrl.unwrap(value): java.lang.String
        )
      )(_.accountUrl)
      .optionallyWith(
        privateKey.map(value =>
          SnowflakePrivateKey.unwrap(value): java.lang.String
        )
      )(_.privateKey)
      .optionallyWith(
        keyPassphrase.map(value =>
          SnowflakeKeyPassphrase.unwrap(value): java.lang.String
        )
      )(_.keyPassphrase)
      .optionallyWith(
        user.map(value => SnowflakeUser.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        database.map(value => SnowflakeDatabase.unwrap(value): java.lang.String)
      )(_.database)
      .optionallyWith(
        schema.map(value => SnowflakeSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .optionallyWith(
        table.map(value => SnowflakeTable.unwrap(value): java.lang.String)
      )(_.table)
      .optionallyWith(
        snowflakeRoleConfiguration.map(value => value.buildAwsValue())
      )(_.snowflakeRoleConfiguration)
      .optionallyWith(dataLoadingOption.map(value => value.unwrap))(
        _.dataLoadingOption
      )
      .optionallyWith(
        metaDataColumnName.map(value =>
          SnowflakeMetaDataColumnName.unwrap(value): java.lang.String
        )
      )(_.metaDataColumnName)
      .optionallyWith(
        contentColumnName.map(value =>
          SnowflakeContentColumnName.unwrap(value): java.lang.String
        )
      )(_.contentColumnName)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(s3Update.map(value => value.buildAwsValue()))(_.s3Update)
      .optionallyWith(
        secretsManagerConfiguration.map(value => value.buildAwsValue())
      )(_.secretsManagerConfiguration)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SnowflakeDestinationUpdate.ReadOnly =
    zio.aws.firehose.model.SnowflakeDestinationUpdate.wrap(buildAwsValue())
}
object SnowflakeDestinationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SnowflakeDestinationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SnowflakeDestinationUpdate =
      zio.aws.firehose.model.SnowflakeDestinationUpdate(
        accountUrl.map(value => value),
        privateKey.map(value => value),
        keyPassphrase.map(value => value),
        user.map(value => value),
        database.map(value => value),
        schema.map(value => value),
        table.map(value => value),
        snowflakeRoleConfiguration.map(value => value.asEditable),
        dataLoadingOption.map(value => value),
        metaDataColumnName.map(value => value),
        contentColumnName.map(value => value),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        roleARN.map(value => value),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3Update.map(value => value.asEditable),
        secretsManagerConfiguration.map(value => value.asEditable),
        bufferingHints.map(value => value.asEditable)
      )
    def accountUrl: Optional[SnowflakeAccountUrl]
    def privateKey: Optional[SnowflakePrivateKey]
    def keyPassphrase: Optional[SnowflakeKeyPassphrase]
    def user: Optional[SnowflakeUser]
    def database: Optional[SnowflakeDatabase]
    def schema: Optional[SnowflakeSchema]
    def table: Optional[SnowflakeTable]
    def snowflakeRoleConfiguration
        : Optional[zio.aws.firehose.model.SnowflakeRoleConfiguration.ReadOnly]
    def dataLoadingOption
        : Optional[zio.aws.firehose.model.SnowflakeDataLoadingOption]
    def metaDataColumnName: Optional[SnowflakeMetaDataColumnName]
    def contentColumnName: Optional[SnowflakeContentColumnName]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def roleARN: Optional[RoleARN]
    def retryOptions
        : Optional[zio.aws.firehose.model.SnowflakeRetryOptions.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.SnowflakeS3BackupMode]
    def s3Update: Optional[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly]
    def secretsManagerConfiguration
        : Optional[zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly]
    def bufferingHints
        : Optional[zio.aws.firehose.model.SnowflakeBufferingHints.ReadOnly]
    def getAccountUrl: ZIO[Any, AwsError, SnowflakeAccountUrl] =
      AwsError.unwrapOptionField("accountUrl", accountUrl)
    def getPrivateKey: ZIO[Any, AwsError, SnowflakePrivateKey] =
      AwsError.unwrapOptionField("privateKey", privateKey)
    def getKeyPassphrase: ZIO[Any, AwsError, SnowflakeKeyPassphrase] =
      AwsError.unwrapOptionField("keyPassphrase", keyPassphrase)
    def getUser: ZIO[Any, AwsError, SnowflakeUser] =
      AwsError.unwrapOptionField("user", user)
    def getDatabase: ZIO[Any, AwsError, SnowflakeDatabase] =
      AwsError.unwrapOptionField("database", database)
    def getSchema: ZIO[Any, AwsError, SnowflakeSchema] =
      AwsError.unwrapOptionField("schema", schema)
    def getTable: ZIO[Any, AwsError, SnowflakeTable] =
      AwsError.unwrapOptionField("table", table)
    def getSnowflakeRoleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SnowflakeRoleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "snowflakeRoleConfiguration",
      snowflakeRoleConfiguration
    )
    def getDataLoadingOption: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SnowflakeDataLoadingOption
    ] = AwsError.unwrapOptionField("dataLoadingOption", dataLoadingOption)
    def getMetaDataColumnName: ZIO[Any, AwsError, SnowflakeMetaDataColumnName] =
      AwsError.unwrapOptionField("metaDataColumnName", metaDataColumnName)
    def getContentColumnName: ZIO[Any, AwsError, SnowflakeContentColumnName] =
      AwsError.unwrapOptionField("contentColumnName", contentColumnName)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SnowflakeRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.SnowflakeS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3Update: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3Update", s3Update)
    def getSecretsManagerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "secretsManagerConfiguration",
      secretsManagerConfiguration
    )
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SnowflakeBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeDestinationUpdate
  ) extends zio.aws.firehose.model.SnowflakeDestinationUpdate.ReadOnly {
    override val accountUrl: Optional[SnowflakeAccountUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountUrl())
        .map(value =>
          zio.aws.firehose.model.primitives.SnowflakeAccountUrl(value)
        )
    override val privateKey: Optional[SnowflakePrivateKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateKey())
        .map(value =>
          zio.aws.firehose.model.primitives.SnowflakePrivateKey(value)
        )
    override val keyPassphrase: Optional[SnowflakeKeyPassphrase] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPassphrase())
        .map(value =>
          zio.aws.firehose.model.primitives.SnowflakeKeyPassphrase(value)
        )
    override val user: Optional[SnowflakeUser] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => zio.aws.firehose.model.primitives.SnowflakeUser(value))
    override val database: Optional[SnowflakeDatabase] = zio.aws.core.internal
      .optionalFromNullable(impl.database())
      .map(value => zio.aws.firehose.model.primitives.SnowflakeDatabase(value))
    override val schema: Optional[SnowflakeSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => zio.aws.firehose.model.primitives.SnowflakeSchema(value))
    override val table: Optional[SnowflakeTable] = zio.aws.core.internal
      .optionalFromNullable(impl.table())
      .map(value => zio.aws.firehose.model.primitives.SnowflakeTable(value))
    override val snowflakeRoleConfiguration
        : Optional[zio.aws.firehose.model.SnowflakeRoleConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snowflakeRoleConfiguration())
        .map(value =>
          zio.aws.firehose.model.SnowflakeRoleConfiguration.wrap(value)
        )
    override val dataLoadingOption
        : Optional[zio.aws.firehose.model.SnowflakeDataLoadingOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataLoadingOption())
        .map(value =>
          zio.aws.firehose.model.SnowflakeDataLoadingOption.wrap(value)
        )
    override val metaDataColumnName: Optional[SnowflakeMetaDataColumnName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metaDataColumnName())
        .map(value =>
          zio.aws.firehose.model.primitives.SnowflakeMetaDataColumnName(value)
        )
    override val contentColumnName: Optional[SnowflakeContentColumnName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentColumnName())
        .map(value =>
          zio.aws.firehose.model.primitives.SnowflakeContentColumnName(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val retryOptions
        : Optional[zio.aws.firehose.model.SnowflakeRetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value => zio.aws.firehose.model.SnowflakeRetryOptions.wrap(value))
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.SnowflakeS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.SnowflakeS3BackupMode.wrap(value))
    override val s3Update
        : Optional[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Update())
        .map(value => zio.aws.firehose.model.S3DestinationUpdate.wrap(value))
    override val secretsManagerConfiguration: Optional[
      zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secretsManagerConfiguration())
      .map(value =>
        zio.aws.firehose.model.SecretsManagerConfiguration.wrap(value)
      )
    override val bufferingHints
        : Optional[zio.aws.firehose.model.SnowflakeBufferingHints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bufferingHints())
        .map(value =>
          zio.aws.firehose.model.SnowflakeBufferingHints.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeDestinationUpdate
  ): zio.aws.firehose.model.SnowflakeDestinationUpdate.ReadOnly = new Wrapper(
    impl
  )
}
