package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.SnowflakeRetryDurationInSeconds
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SnowflakeRetryOptions(
    durationInSeconds: Optional[SnowflakeRetryDurationInSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SnowflakeRetryOptions = {
    import SnowflakeRetryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SnowflakeRetryOptions
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          SnowflakeRetryDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SnowflakeRetryOptions.ReadOnly =
    zio.aws.firehose.model.SnowflakeRetryOptions.wrap(buildAwsValue())
}
object SnowflakeRetryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SnowflakeRetryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SnowflakeRetryOptions =
      zio.aws.firehose.model
        .SnowflakeRetryOptions(durationInSeconds.map(value => value))
    def durationInSeconds: Optional[SnowflakeRetryDurationInSeconds]
    def getDurationInSeconds
        : ZIO[Any, AwsError, SnowflakeRetryDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeRetryOptions
  ) extends zio.aws.firehose.model.SnowflakeRetryOptions.ReadOnly {
    override val durationInSeconds: Optional[SnowflakeRetryDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives
            .SnowflakeRetryDurationInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeRetryOptions
  ): zio.aws.firehose.model.SnowflakeRetryOptions.ReadOnly = new Wrapper(impl)
}
