package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{SnowflakeRole, BooleanObject}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnowflakeRoleConfiguration(
    enabled: Optional[BooleanObject] = Optional.Absent,
    snowflakeRole: Optional[SnowflakeRole] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SnowflakeRoleConfiguration = {
    import SnowflakeRoleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SnowflakeRoleConfiguration
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        snowflakeRole.map(value =>
          SnowflakeRole.unwrap(value): java.lang.String
        )
      )(_.snowflakeRole)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SnowflakeRoleConfiguration.ReadOnly =
    zio.aws.firehose.model.SnowflakeRoleConfiguration.wrap(buildAwsValue())
}
object SnowflakeRoleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SnowflakeRoleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SnowflakeRoleConfiguration =
      zio.aws.firehose.model.SnowflakeRoleConfiguration(
        enabled.map(value => value),
        snowflakeRole.map(value => value)
      )
    def enabled: Optional[BooleanObject]
    def snowflakeRole: Optional[SnowflakeRole]
    def getEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getSnowflakeRole: ZIO[Any, AwsError, SnowflakeRole] =
      AwsError.unwrapOptionField("snowflakeRole", snowflakeRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeRoleConfiguration
  ) extends zio.aws.firehose.model.SnowflakeRoleConfiguration.ReadOnly {
    override val enabled: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: BooleanObject)
    override val snowflakeRole: Optional[SnowflakeRole] = zio.aws.core.internal
      .optionalFromNullable(impl.snowflakeRole())
      .map(value => zio.aws.firehose.model.primitives.SnowflakeRole(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeRoleConfiguration
  ): zio.aws.firehose.model.SnowflakeRoleConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
