package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait SnowflakeS3BackupMode {
  def unwrap
      : software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode
}
object SnowflakeS3BackupMode {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode
  ): zio.aws.firehose.model.SnowflakeS3BackupMode = value match {
    case software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode.FAILED_DATA_ONLY =>
      val r = FailedDataOnly
      r
    case software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode.ALL_DATA =>
      val r = AllData
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.SnowflakeS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode =
      software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FailedDataOnly
      extends zio.aws.firehose.model.SnowflakeS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode =
      software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode.FAILED_DATA_ONLY
  }
  case object AllData extends zio.aws.firehose.model.SnowflakeS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode =
      software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode.ALL_DATA
  }
}
