package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.SnowflakePrivateLinkVpceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SnowflakeVpcConfiguration(
    privateLinkVpceId: SnowflakePrivateLinkVpceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SnowflakeVpcConfiguration = {
    import SnowflakeVpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SnowflakeVpcConfiguration
      .builder()
      .privateLinkVpceId(
        SnowflakePrivateLinkVpceId.unwrap(privateLinkVpceId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SnowflakeVpcConfiguration.ReadOnly =
    zio.aws.firehose.model.SnowflakeVpcConfiguration.wrap(buildAwsValue())
}
object SnowflakeVpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SnowflakeVpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SnowflakeVpcConfiguration =
      zio.aws.firehose.model.SnowflakeVpcConfiguration(privateLinkVpceId)
    def privateLinkVpceId: SnowflakePrivateLinkVpceId
    def getPrivateLinkVpceId: ZIO[Any, Nothing, SnowflakePrivateLinkVpceId] =
      ZIO.succeed(privateLinkVpceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeVpcConfiguration
  ) extends zio.aws.firehose.model.SnowflakeVpcConfiguration.ReadOnly {
    override val privateLinkVpceId: SnowflakePrivateLinkVpceId =
      zio.aws.firehose.model.primitives
        .SnowflakePrivateLinkVpceId(impl.privateLinkVpceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SnowflakeVpcConfiguration
  ): zio.aws.firehose.model.SnowflakeVpcConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
