package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  SplunkBufferingSizeInMBs,
  SplunkBufferingIntervalInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SplunkBufferingHints(
    intervalInSeconds: Optional[SplunkBufferingIntervalInSeconds] =
      Optional.Absent,
    sizeInMBs: Optional[SplunkBufferingSizeInMBs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SplunkBufferingHints = {
    import SplunkBufferingHints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SplunkBufferingHints
      .builder()
      .optionallyWith(
        intervalInSeconds.map(value =>
          SplunkBufferingIntervalInSeconds.unwrap(value): Integer
        )
      )(_.intervalInSeconds)
      .optionallyWith(
        sizeInMBs.map(value => SplunkBufferingSizeInMBs.unwrap(value): Integer)
      )(_.sizeInMBs)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SplunkBufferingHints.ReadOnly =
    zio.aws.firehose.model.SplunkBufferingHints.wrap(buildAwsValue())
}
object SplunkBufferingHints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SplunkBufferingHints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SplunkBufferingHints =
      zio.aws.firehose.model.SplunkBufferingHints(
        intervalInSeconds.map(value => value),
        sizeInMBs.map(value => value)
      )
    def intervalInSeconds: Optional[SplunkBufferingIntervalInSeconds]
    def sizeInMBs: Optional[SplunkBufferingSizeInMBs]
    def getIntervalInSeconds
        : ZIO[Any, AwsError, SplunkBufferingIntervalInSeconds] =
      AwsError.unwrapOptionField("intervalInSeconds", intervalInSeconds)
    def getSizeInMBs: ZIO[Any, AwsError, SplunkBufferingSizeInMBs] =
      AwsError.unwrapOptionField("sizeInMBs", sizeInMBs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SplunkBufferingHints
  ) extends zio.aws.firehose.model.SplunkBufferingHints.ReadOnly {
    override val intervalInSeconds: Optional[SplunkBufferingIntervalInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives
            .SplunkBufferingIntervalInSeconds(value)
        )
    override val sizeInMBs: Optional[SplunkBufferingSizeInMBs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeInMBs())
        .map(value =>
          zio.aws.firehose.model.primitives.SplunkBufferingSizeInMBs(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SplunkBufferingHints
  ): zio.aws.firehose.model.SplunkBufferingHints.ReadOnly = new Wrapper(impl)
}
