package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  HECAcknowledgmentTimeoutInSeconds,
  HECToken,
  HECEndpoint
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SplunkDestinationDescription(
    hecEndpoint: Optional[HECEndpoint] = Optional.Absent,
    hecEndpointType: Optional[zio.aws.firehose.model.HECEndpointType] =
      Optional.Absent,
    hecToken: Optional[HECToken] = Optional.Absent,
    hecAcknowledgmentTimeoutInSeconds: Optional[
      HECAcknowledgmentTimeoutInSeconds
    ] = Optional.Absent,
    retryOptions: Optional[zio.aws.firehose.model.SplunkRetryOptions] =
      Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.SplunkS3BackupMode] =
      Optional.Absent,
    s3DestinationDescription: Optional[
      zio.aws.firehose.model.S3DestinationDescription
    ] = Optional.Absent,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    bufferingHints: Optional[zio.aws.firehose.model.SplunkBufferingHints] =
      Optional.Absent,
    secretsManagerConfiguration: Optional[
      zio.aws.firehose.model.SecretsManagerConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.SplunkDestinationDescription = {
    import SplunkDestinationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.SplunkDestinationDescription
      .builder()
      .optionallyWith(
        hecEndpoint.map(value => HECEndpoint.unwrap(value): java.lang.String)
      )(_.hecEndpoint)
      .optionallyWith(hecEndpointType.map(value => value.unwrap))(
        _.hecEndpointType
      )
      .optionallyWith(
        hecToken.map(value => HECToken.unwrap(value): java.lang.String)
      )(_.hecToken)
      .optionallyWith(
        hecAcknowledgmentTimeoutInSeconds.map(value =>
          HECAcknowledgmentTimeoutInSeconds.unwrap(value): Integer
        )
      )(_.hecAcknowledgmentTimeoutInSeconds)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(
        s3DestinationDescription.map(value => value.buildAwsValue())
      )(_.s3DestinationDescription)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(
        secretsManagerConfiguration.map(value => value.buildAwsValue())
      )(_.secretsManagerConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.SplunkDestinationDescription.ReadOnly =
    zio.aws.firehose.model.SplunkDestinationDescription.wrap(buildAwsValue())
}
object SplunkDestinationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.SplunkDestinationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.SplunkDestinationDescription =
      zio.aws.firehose.model.SplunkDestinationDescription(
        hecEndpoint.map(value => value),
        hecEndpointType.map(value => value),
        hecToken.map(value => value),
        hecAcknowledgmentTimeoutInSeconds.map(value => value),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3DestinationDescription.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        bufferingHints.map(value => value.asEditable),
        secretsManagerConfiguration.map(value => value.asEditable)
      )
    def hecEndpoint: Optional[HECEndpoint]
    def hecEndpointType: Optional[zio.aws.firehose.model.HECEndpointType]
    def hecToken: Optional[HECToken]
    def hecAcknowledgmentTimeoutInSeconds
        : Optional[HECAcknowledgmentTimeoutInSeconds]
    def retryOptions
        : Optional[zio.aws.firehose.model.SplunkRetryOptions.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.SplunkS3BackupMode]
    def s3DestinationDescription
        : Optional[zio.aws.firehose.model.S3DestinationDescription.ReadOnly]
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def bufferingHints
        : Optional[zio.aws.firehose.model.SplunkBufferingHints.ReadOnly]
    def secretsManagerConfiguration
        : Optional[zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly]
    def getHecEndpoint: ZIO[Any, AwsError, HECEndpoint] =
      AwsError.unwrapOptionField("hecEndpoint", hecEndpoint)
    def getHecEndpointType
        : ZIO[Any, AwsError, zio.aws.firehose.model.HECEndpointType] =
      AwsError.unwrapOptionField("hecEndpointType", hecEndpointType)
    def getHecToken: ZIO[Any, AwsError, HECToken] =
      AwsError.unwrapOptionField("hecToken", hecToken)
    def getHecAcknowledgmentTimeoutInSeconds
        : ZIO[Any, AwsError, HECAcknowledgmentTimeoutInSeconds] =
      AwsError.unwrapOptionField(
        "hecAcknowledgmentTimeoutInSeconds",
        hecAcknowledgmentTimeoutInSeconds
      )
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SplunkRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.SplunkS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3DestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3DestinationDescription",
      s3DestinationDescription
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SplunkBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getSecretsManagerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "secretsManagerConfiguration",
      secretsManagerConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.SplunkDestinationDescription
  ) extends zio.aws.firehose.model.SplunkDestinationDescription.ReadOnly {
    override val hecEndpoint: Optional[HECEndpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.hecEndpoint())
      .map(value => zio.aws.firehose.model.primitives.HECEndpoint(value))
    override val hecEndpointType
        : Optional[zio.aws.firehose.model.HECEndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hecEndpointType())
        .map(value => zio.aws.firehose.model.HECEndpointType.wrap(value))
    override val hecToken: Optional[HECToken] = zio.aws.core.internal
      .optionalFromNullable(impl.hecToken())
      .map(value => zio.aws.firehose.model.primitives.HECToken(value))
    override val hecAcknowledgmentTimeoutInSeconds
        : Optional[HECAcknowledgmentTimeoutInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.hecAcknowledgmentTimeoutInSeconds())
      .map(value =>
        zio.aws.firehose.model.primitives
          .HECAcknowledgmentTimeoutInSeconds(value)
      )
    override val retryOptions
        : Optional[zio.aws.firehose.model.SplunkRetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value => zio.aws.firehose.model.SplunkRetryOptions.wrap(value))
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.SplunkS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.SplunkS3BackupMode.wrap(value))
    override val s3DestinationDescription
        : Optional[zio.aws.firehose.model.S3DestinationDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3DestinationDescription())
        .map(value =>
          zio.aws.firehose.model.S3DestinationDescription.wrap(value)
        )
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val bufferingHints
        : Optional[zio.aws.firehose.model.SplunkBufferingHints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bufferingHints())
        .map(value => zio.aws.firehose.model.SplunkBufferingHints.wrap(value))
    override val secretsManagerConfiguration: Optional[
      zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secretsManagerConfiguration())
      .map(value =>
        zio.aws.firehose.model.SecretsManagerConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.SplunkDestinationDescription
  ): zio.aws.firehose.model.SplunkDestinationDescription.ReadOnly = new Wrapper(
    impl
  )
}
