package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait SplunkS3BackupMode {
  def unwrap: software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode
}
object SplunkS3BackupMode {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode
  ): zio.aws.firehose.model.SplunkS3BackupMode = value match {
    case software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode.FAILED_EVENTS_ONLY =>
      val r = FailedEventsOnly
      r
    case software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode.ALL_EVENTS =>
      val r = AllEvents
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.SplunkS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode =
      software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FailedEventsOnly
      extends zio.aws.firehose.model.SplunkS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode =
      software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode.FAILED_EVENTS_ONLY
  }
  case object AllEvents extends zio.aws.firehose.model.SplunkS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode =
      software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode.ALL_EVENTS
  }
}
