package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.DeliveryStreamName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopDeliveryStreamEncryptionRequest(
    deliveryStreamName: DeliveryStreamName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.StopDeliveryStreamEncryptionRequest = {
    import StopDeliveryStreamEncryptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.StopDeliveryStreamEncryptionRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.StopDeliveryStreamEncryptionRequest.ReadOnly =
    zio.aws.firehose.model.StopDeliveryStreamEncryptionRequest
      .wrap(buildAwsValue())
}
object StopDeliveryStreamEncryptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.StopDeliveryStreamEncryptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.StopDeliveryStreamEncryptionRequest =
      zio.aws.firehose.model
        .StopDeliveryStreamEncryptionRequest(deliveryStreamName)
    def deliveryStreamName: DeliveryStreamName
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.StopDeliveryStreamEncryptionRequest
  ) extends zio.aws.firehose.model.StopDeliveryStreamEncryptionRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.StopDeliveryStreamEncryptionRequest
  ): zio.aws.firehose.model.StopDeliveryStreamEncryptionRequest.ReadOnly =
    new Wrapper(impl)
}
