package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.DeliveryStreamName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagDeliveryStreamRequest(
    deliveryStreamName: DeliveryStreamName,
    tags: Iterable[zio.aws.firehose.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.TagDeliveryStreamRequest = {
    import TagDeliveryStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.TagDeliveryStreamRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.TagDeliveryStreamRequest.ReadOnly =
    zio.aws.firehose.model.TagDeliveryStreamRequest.wrap(buildAwsValue())
}
object TagDeliveryStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.TagDeliveryStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.TagDeliveryStreamRequest =
      zio.aws.firehose.model.TagDeliveryStreamRequest(
        deliveryStreamName,
        tags.map { item =>
          item.asEditable
        }
      )
    def deliveryStreamName: DeliveryStreamName
    def tags: List[zio.aws.firehose.model.Tag.ReadOnly]
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getTags: ZIO[Any, Nothing, List[zio.aws.firehose.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.TagDeliveryStreamRequest
  ) extends zio.aws.firehose.model.TagDeliveryStreamRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val tags: List[zio.aws.firehose.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.firehose.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.TagDeliveryStreamRequest
  ): zio.aws.firehose.model.TagDeliveryStreamRequest.ReadOnly = new Wrapper(
    impl
  )
}
