package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{TagKey, DeliveryStreamName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagDeliveryStreamRequest(
    deliveryStreamName: DeliveryStreamName,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamRequest = {
    import UntagDeliveryStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.UntagDeliveryStreamRequest.ReadOnly =
    zio.aws.firehose.model.UntagDeliveryStreamRequest.wrap(buildAwsValue())
}
object UntagDeliveryStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.UntagDeliveryStreamRequest =
      zio.aws.firehose.model
        .UntagDeliveryStreamRequest(deliveryStreamName, tagKeys)
    def deliveryStreamName: DeliveryStreamName
    def tagKeys: List[TagKey]
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamRequest
  ) extends zio.aws.firehose.model.UntagDeliveryStreamRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.firehose.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamRequest
  ): zio.aws.firehose.model.UntagDeliveryStreamRequest.ReadOnly = new Wrapper(
    impl
  )
}
