package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  RoleARN,
  NonEmptyStringWithoutWhitespace
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VpcConfigurationDescription(
    subnetIds: Iterable[NonEmptyStringWithoutWhitespace],
    roleARN: RoleARN,
    securityGroupIds: Iterable[NonEmptyStringWithoutWhitespace],
    vpcId: NonEmptyStringWithoutWhitespace
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.VpcConfigurationDescription = {
    import VpcConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.VpcConfigurationDescription
      .builder()
      .subnetIds(subnetIds.map { item =>
        NonEmptyStringWithoutWhitespace.unwrap(item): java.lang.String
      }.asJavaCollection)
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .securityGroupIds(securityGroupIds.map { item =>
        NonEmptyStringWithoutWhitespace.unwrap(item): java.lang.String
      }.asJavaCollection)
      .vpcId(NonEmptyStringWithoutWhitespace.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly =
    zio.aws.firehose.model.VpcConfigurationDescription.wrap(buildAwsValue())
}
object VpcConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.VpcConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.VpcConfigurationDescription =
      zio.aws.firehose.model.VpcConfigurationDescription(
        subnetIds,
        roleARN,
        securityGroupIds,
        vpcId
      )
    def subnetIds: List[NonEmptyStringWithoutWhitespace]
    def roleARN: RoleARN
    def securityGroupIds: List[NonEmptyStringWithoutWhitespace]
    def vpcId: NonEmptyStringWithoutWhitespace
    def getSubnetIds: ZIO[Any, Nothing, List[NonEmptyStringWithoutWhitespace]] =
      ZIO.succeed(subnetIds)
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getSecurityGroupIds
        : ZIO[Any, Nothing, List[NonEmptyStringWithoutWhitespace]] =
      ZIO.succeed(securityGroupIds)
    def getVpcId: ZIO[Any, Nothing, NonEmptyStringWithoutWhitespace] =
      ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.VpcConfigurationDescription
  ) extends zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly {
    override val subnetIds: List[NonEmptyStringWithoutWhitespace] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.firehose.model.primitives.NonEmptyStringWithoutWhitespace(item)
      }
      .toList
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val securityGroupIds: List[NonEmptyStringWithoutWhitespace] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.firehose.model.primitives.NonEmptyStringWithoutWhitespace(item)
      }
      .toList
    override val vpcId: NonEmptyStringWithoutWhitespace =
      zio.aws.firehose.model.primitives
        .NonEmptyStringWithoutWhitespace(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.VpcConfigurationDescription
  ): zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly = new Wrapper(
    impl
  )
}
