package zio.aws.firehose
import zio.aws.firehose.model.primitives.HttpEndpointName.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.firehose.model.primitives.{
  TagKey,
  DeliveryStreamName,
  NonEmptyString,
  NonEmptyStringWithoutWhitespace
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AWSKMSKeyARN extends zio.prelude.Subtype[String]
    type AWSKMSKeyARN = zio.aws.firehose.model.primitives.AWSKMSKeyARN.Type
    object AmazonOpenSearchServerlessBufferingIntervalInSeconds
        extends zio.prelude.Subtype[Int]
    type AmazonOpenSearchServerlessBufferingIntervalInSeconds =
      zio.aws.firehose.model.primitives.AmazonOpenSearchServerlessBufferingIntervalInSeconds.Type
    object AmazonOpenSearchServerlessBufferingSizeInMBs
        extends zio.prelude.Subtype[Int]
    type AmazonOpenSearchServerlessBufferingSizeInMBs =
      zio.aws.firehose.model.primitives.AmazonOpenSearchServerlessBufferingSizeInMBs.Type
    object AmazonOpenSearchServerlessCollectionEndpoint
        extends zio.prelude.Subtype[String]
    type AmazonOpenSearchServerlessCollectionEndpoint =
      zio.aws.firehose.model.primitives.AmazonOpenSearchServerlessCollectionEndpoint.Type
    object AmazonOpenSearchServerlessIndexName
        extends zio.prelude.Subtype[String]
    type AmazonOpenSearchServerlessIndexName =
      zio.aws.firehose.model.primitives.AmazonOpenSearchServerlessIndexName.Type
    object AmazonOpenSearchServerlessRetryDurationInSeconds
        extends zio.prelude.Subtype[Int]
    type AmazonOpenSearchServerlessRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.AmazonOpenSearchServerlessRetryDurationInSeconds.Type
    object AmazonopensearchserviceBufferingIntervalInSeconds
        extends zio.prelude.Subtype[Int]
    type AmazonopensearchserviceBufferingIntervalInSeconds =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceBufferingIntervalInSeconds.Type
    object AmazonopensearchserviceBufferingSizeInMBs
        extends zio.prelude.Subtype[Int]
    type AmazonopensearchserviceBufferingSizeInMBs =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceBufferingSizeInMBs.Type
    object AmazonopensearchserviceClusterEndpoint
        extends zio.prelude.Subtype[String]
    type AmazonopensearchserviceClusterEndpoint =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceClusterEndpoint.Type
    object AmazonopensearchserviceDomainARN extends zio.prelude.Subtype[String]
    type AmazonopensearchserviceDomainARN =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceDomainARN.Type
    object AmazonopensearchserviceIndexName extends zio.prelude.Subtype[String]
    type AmazonopensearchserviceIndexName =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceIndexName.Type
    object AmazonopensearchserviceRetryDurationInSeconds
        extends zio.prelude.Subtype[Int]
    type AmazonopensearchserviceRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceRetryDurationInSeconds.Type
    object AmazonopensearchserviceTypeName extends zio.prelude.Subtype[String]
    type AmazonopensearchserviceTypeName =
      zio.aws.firehose.model.primitives.AmazonopensearchserviceTypeName.Type
    object BlockSizeBytes extends zio.prelude.Subtype[Int]
    type BlockSizeBytes = zio.aws.firehose.model.primitives.BlockSizeBytes.Type
    type BooleanObject = Boolean
    object BucketARN extends zio.prelude.Subtype[String]
    type BucketARN = zio.aws.firehose.model.primitives.BucketARN.Type
    object ClusterJDBCURL extends zio.prelude.Subtype[String]
    type ClusterJDBCURL = zio.aws.firehose.model.primitives.ClusterJDBCURL.Type
    object CopyOptions extends zio.prelude.Subtype[String]
    type CopyOptions = zio.aws.firehose.model.primitives.CopyOptions.Type
    object CustomTimeZone extends zio.prelude.Subtype[String]
    type CustomTimeZone = zio.aws.firehose.model.primitives.CustomTimeZone.Type
    object Data extends zio.prelude.Subtype[Chunk[Byte]]
    type Data = zio.aws.firehose.model.primitives.Data.Type
    object DataTableColumns extends zio.prelude.Subtype[String]
    type DataTableColumns =
      zio.aws.firehose.model.primitives.DataTableColumns.Type
    object DataTableName extends zio.prelude.Subtype[String]
    type DataTableName = zio.aws.firehose.model.primitives.DataTableName.Type
    object DeliveryStartTimestamp extends zio.prelude.Subtype[Instant]
    type DeliveryStartTimestamp =
      zio.aws.firehose.model.primitives.DeliveryStartTimestamp.Type
    object DeliveryStreamARN extends zio.prelude.Subtype[String]
    type DeliveryStreamARN =
      zio.aws.firehose.model.primitives.DeliveryStreamARN.Type
    object DeliveryStreamName extends zio.prelude.Subtype[String]
    type DeliveryStreamName =
      zio.aws.firehose.model.primitives.DeliveryStreamName.Type
    object DeliveryStreamVersionId extends zio.prelude.Subtype[String]
    type DeliveryStreamVersionId =
      zio.aws.firehose.model.primitives.DeliveryStreamVersionId.Type
    object DescribeDeliveryStreamInputLimit extends zio.prelude.Subtype[Int]
    type DescribeDeliveryStreamInputLimit =
      zio.aws.firehose.model.primitives.DescribeDeliveryStreamInputLimit.Type
    object DestinationId extends zio.prelude.Subtype[String]
    type DestinationId = zio.aws.firehose.model.primitives.DestinationId.Type
    object ElasticsearchBufferingIntervalInSeconds
        extends zio.prelude.Subtype[Int]
    type ElasticsearchBufferingIntervalInSeconds =
      zio.aws.firehose.model.primitives.ElasticsearchBufferingIntervalInSeconds.Type
    object ElasticsearchBufferingSizeInMBs extends zio.prelude.Subtype[Int]
    type ElasticsearchBufferingSizeInMBs =
      zio.aws.firehose.model.primitives.ElasticsearchBufferingSizeInMBs.Type
    object ElasticsearchClusterEndpoint extends zio.prelude.Subtype[String]
    type ElasticsearchClusterEndpoint =
      zio.aws.firehose.model.primitives.ElasticsearchClusterEndpoint.Type
    object ElasticsearchDomainARN extends zio.prelude.Subtype[String]
    type ElasticsearchDomainARN =
      zio.aws.firehose.model.primitives.ElasticsearchDomainARN.Type
    object ElasticsearchIndexName extends zio.prelude.Subtype[String]
    type ElasticsearchIndexName =
      zio.aws.firehose.model.primitives.ElasticsearchIndexName.Type
    object ElasticsearchRetryDurationInSeconds extends zio.prelude.Subtype[Int]
    type ElasticsearchRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.ElasticsearchRetryDurationInSeconds.Type
    object ElasticsearchTypeName extends zio.prelude.Subtype[String]
    type ElasticsearchTypeName =
      zio.aws.firehose.model.primitives.ElasticsearchTypeName.Type
    object ErrorCode extends zio.prelude.Subtype[String]
    type ErrorCode = zio.aws.firehose.model.primitives.ErrorCode.Type
    object ErrorMessage extends zio.prelude.Subtype[String]
    type ErrorMessage = zio.aws.firehose.model.primitives.ErrorMessage.Type
    object ErrorOutputPrefix extends zio.prelude.Subtype[String]
    type ErrorOutputPrefix =
      zio.aws.firehose.model.primitives.ErrorOutputPrefix.Type
    object FileExtension extends zio.prelude.Subtype[String]
    type FileExtension = zio.aws.firehose.model.primitives.FileExtension.Type
    object GlueDataCatalogARN extends zio.prelude.Subtype[String]
    type GlueDataCatalogARN =
      zio.aws.firehose.model.primitives.GlueDataCatalogARN.Type
    object HECAcknowledgmentTimeoutInSeconds extends zio.prelude.Subtype[Int]
    type HECAcknowledgmentTimeoutInSeconds =
      zio.aws.firehose.model.primitives.HECAcknowledgmentTimeoutInSeconds.Type
    object HECEndpoint extends zio.prelude.Subtype[String]
    type HECEndpoint = zio.aws.firehose.model.primitives.HECEndpoint.Type
    object HECToken extends zio.prelude.Subtype[String]
    type HECToken = zio.aws.firehose.model.primitives.HECToken.Type
    object HttpEndpointAccessKey extends zio.prelude.Subtype[String]
    type HttpEndpointAccessKey =
      zio.aws.firehose.model.primitives.HttpEndpointAccessKey.Type
    object HttpEndpointAttributeName extends zio.prelude.Subtype[String]
    type HttpEndpointAttributeName =
      zio.aws.firehose.model.primitives.HttpEndpointAttributeName.Type
    object HttpEndpointAttributeValue extends zio.prelude.Subtype[String]
    type HttpEndpointAttributeValue =
      zio.aws.firehose.model.primitives.HttpEndpointAttributeValue.Type
    object HttpEndpointBufferingIntervalInSeconds
        extends zio.prelude.Subtype[Int]
    type HttpEndpointBufferingIntervalInSeconds =
      zio.aws.firehose.model.primitives.HttpEndpointBufferingIntervalInSeconds.Type
    object HttpEndpointBufferingSizeInMBs extends zio.prelude.Subtype[Int]
    type HttpEndpointBufferingSizeInMBs =
      zio.aws.firehose.model.primitives.HttpEndpointBufferingSizeInMBs.Type
    object HttpEndpointName extends zio.prelude.Subtype[String]
    type HttpEndpointName =
      zio.aws.firehose.model.primitives.HttpEndpointName.Type
    object HttpEndpointRetryDurationInSeconds extends zio.prelude.Subtype[Int]
    type HttpEndpointRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.HttpEndpointRetryDurationInSeconds.Type
    object HttpEndpointUrl extends zio.prelude.Subtype[String]
    type HttpEndpointUrl =
      zio.aws.firehose.model.primitives.HttpEndpointUrl.Type
    object IntervalInSeconds extends zio.prelude.Subtype[Int]
    type IntervalInSeconds =
      zio.aws.firehose.model.primitives.IntervalInSeconds.Type
    object KinesisStreamARN extends zio.prelude.Subtype[String]
    type KinesisStreamARN =
      zio.aws.firehose.model.primitives.KinesisStreamARN.Type
    object ListDeliveryStreamsInputLimit extends zio.prelude.Subtype[Int]
    type ListDeliveryStreamsInputLimit =
      zio.aws.firehose.model.primitives.ListDeliveryStreamsInputLimit.Type
    object ListTagsForDeliveryStreamInputLimit extends zio.prelude.Subtype[Int]
    type ListTagsForDeliveryStreamInputLimit =
      zio.aws.firehose.model.primitives.ListTagsForDeliveryStreamInputLimit.Type
    object LogGroupName extends zio.prelude.Subtype[String]
    type LogGroupName = zio.aws.firehose.model.primitives.LogGroupName.Type
    object LogStreamName extends zio.prelude.Subtype[String]
    type LogStreamName = zio.aws.firehose.model.primitives.LogStreamName.Type
    object MSKClusterARN extends zio.prelude.Subtype[String]
    type MSKClusterARN = zio.aws.firehose.model.primitives.MSKClusterARN.Type
    object NonEmptyString extends zio.prelude.Subtype[String]
    type NonEmptyString = zio.aws.firehose.model.primitives.NonEmptyString.Type
    object NonEmptyStringWithoutWhitespace extends zio.prelude.Subtype[String]
    type NonEmptyStringWithoutWhitespace =
      zio.aws.firehose.model.primitives.NonEmptyStringWithoutWhitespace.Type
    object NonNegativeIntegerObject extends zio.prelude.Subtype[Int]
    type NonNegativeIntegerObject =
      zio.aws.firehose.model.primitives.NonNegativeIntegerObject.Type
    object OrcRowIndexStride extends zio.prelude.Subtype[Int]
    type OrcRowIndexStride =
      zio.aws.firehose.model.primitives.OrcRowIndexStride.Type
    object OrcStripeSizeBytes extends zio.prelude.Subtype[Int]
    type OrcStripeSizeBytes =
      zio.aws.firehose.model.primitives.OrcStripeSizeBytes.Type
    object ParquetPageSizeBytes extends zio.prelude.Subtype[Int]
    type ParquetPageSizeBytes =
      zio.aws.firehose.model.primitives.ParquetPageSizeBytes.Type
    object Password extends zio.prelude.Subtype[String]
    type Password = zio.aws.firehose.model.primitives.Password.Type
    object Prefix extends zio.prelude.Subtype[String]
    type Prefix = zio.aws.firehose.model.primitives.Prefix.Type
    object ProcessorParameterValue extends zio.prelude.Subtype[String]
    type ProcessorParameterValue =
      zio.aws.firehose.model.primitives.ProcessorParameterValue.Type
    object Proportion extends zio.prelude.Subtype[Double]
    type Proportion = zio.aws.firehose.model.primitives.Proportion.Type
    object PutResponseRecordId extends zio.prelude.Subtype[String]
    type PutResponseRecordId =
      zio.aws.firehose.model.primitives.PutResponseRecordId.Type
    object ReadFromTimestamp extends zio.prelude.Subtype[Instant]
    type ReadFromTimestamp =
      zio.aws.firehose.model.primitives.ReadFromTimestamp.Type
    object RedshiftRetryDurationInSeconds extends zio.prelude.Subtype[Int]
    type RedshiftRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.RedshiftRetryDurationInSeconds.Type
    object RetryDurationInSeconds extends zio.prelude.Subtype[Int]
    type RetryDurationInSeconds =
      zio.aws.firehose.model.primitives.RetryDurationInSeconds.Type
    object RoleARN extends zio.prelude.Subtype[String]
    type RoleARN = zio.aws.firehose.model.primitives.RoleARN.Type
    object SecretARN extends zio.prelude.Subtype[String]
    type SecretARN = zio.aws.firehose.model.primitives.SecretARN.Type
    object SizeInMBs extends zio.prelude.Subtype[Int]
    type SizeInMBs = zio.aws.firehose.model.primitives.SizeInMBs.Type
    object SnowflakeAccountUrl extends zio.prelude.Subtype[String]
    type SnowflakeAccountUrl =
      zio.aws.firehose.model.primitives.SnowflakeAccountUrl.Type
    object SnowflakeBufferingIntervalInSeconds extends zio.prelude.Subtype[Int]
    type SnowflakeBufferingIntervalInSeconds =
      zio.aws.firehose.model.primitives.SnowflakeBufferingIntervalInSeconds.Type
    object SnowflakeBufferingSizeInMBs extends zio.prelude.Subtype[Int]
    type SnowflakeBufferingSizeInMBs =
      zio.aws.firehose.model.primitives.SnowflakeBufferingSizeInMBs.Type
    object SnowflakeContentColumnName extends zio.prelude.Subtype[String]
    type SnowflakeContentColumnName =
      zio.aws.firehose.model.primitives.SnowflakeContentColumnName.Type
    object SnowflakeDatabase extends zio.prelude.Subtype[String]
    type SnowflakeDatabase =
      zio.aws.firehose.model.primitives.SnowflakeDatabase.Type
    object SnowflakeKeyPassphrase extends zio.prelude.Subtype[String]
    type SnowflakeKeyPassphrase =
      zio.aws.firehose.model.primitives.SnowflakeKeyPassphrase.Type
    object SnowflakeMetaDataColumnName extends zio.prelude.Subtype[String]
    type SnowflakeMetaDataColumnName =
      zio.aws.firehose.model.primitives.SnowflakeMetaDataColumnName.Type
    object SnowflakePrivateKey extends zio.prelude.Subtype[String]
    type SnowflakePrivateKey =
      zio.aws.firehose.model.primitives.SnowflakePrivateKey.Type
    object SnowflakePrivateLinkVpceId extends zio.prelude.Subtype[String]
    type SnowflakePrivateLinkVpceId =
      zio.aws.firehose.model.primitives.SnowflakePrivateLinkVpceId.Type
    object SnowflakeRetryDurationInSeconds extends zio.prelude.Subtype[Int]
    type SnowflakeRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.SnowflakeRetryDurationInSeconds.Type
    object SnowflakeRole extends zio.prelude.Subtype[String]
    type SnowflakeRole = zio.aws.firehose.model.primitives.SnowflakeRole.Type
    object SnowflakeSchema extends zio.prelude.Subtype[String]
    type SnowflakeSchema =
      zio.aws.firehose.model.primitives.SnowflakeSchema.Type
    object SnowflakeTable extends zio.prelude.Subtype[String]
    type SnowflakeTable = zio.aws.firehose.model.primitives.SnowflakeTable.Type
    object SnowflakeUser extends zio.prelude.Subtype[String]
    type SnowflakeUser = zio.aws.firehose.model.primitives.SnowflakeUser.Type
    object SplunkBufferingIntervalInSeconds extends zio.prelude.Subtype[Int]
    type SplunkBufferingIntervalInSeconds =
      zio.aws.firehose.model.primitives.SplunkBufferingIntervalInSeconds.Type
    object SplunkBufferingSizeInMBs extends zio.prelude.Subtype[Int]
    type SplunkBufferingSizeInMBs =
      zio.aws.firehose.model.primitives.SplunkBufferingSizeInMBs.Type
    object SplunkRetryDurationInSeconds extends zio.prelude.Subtype[Int]
    type SplunkRetryDurationInSeconds =
      zio.aws.firehose.model.primitives.SplunkRetryDurationInSeconds.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.firehose.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.firehose.model.primitives.TagValue.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.firehose.model.primitives.Timestamp.Type
    object TopicName extends zio.prelude.Subtype[String]
    type TopicName = zio.aws.firehose.model.primitives.TopicName.Type
    object Username extends zio.prelude.Subtype[String]
    type Username = zio.aws.firehose.model.primitives.Username.Type
  }
  type ColumnToJsonKeyMappings =
    Map[NonEmptyStringWithoutWhitespace, NonEmptyString]
  type DeliveryStreamNameList = List[DeliveryStreamName]
  type DestinationDescriptionList =
    List[zio.aws.firehose.model.DestinationDescription]
  type DestinationTableConfigurationList =
    List[zio.aws.firehose.model.DestinationTableConfiguration]
  type HttpEndpointCommonAttributesList =
    List[zio.aws.firehose.model.HttpEndpointCommonAttribute]
  type ListOfNonEmptyStrings = List[NonEmptyString]
  type ListOfNonEmptyStringsWithoutWhitespace =
    List[NonEmptyStringWithoutWhitespace]
  type ListTagsForDeliveryStreamOutputTagList = List[zio.aws.firehose.model.Tag]
  type ProcessorList = List[zio.aws.firehose.model.Processor]
  type ProcessorParameterList = List[zio.aws.firehose.model.ProcessorParameter]
  type PutRecordBatchRequestEntryList = List[zio.aws.firehose.model.Record]
  type PutRecordBatchResponseEntryList =
    List[zio.aws.firehose.model.PutRecordBatchResponseEntry]
  type SecurityGroupIdList = List[NonEmptyStringWithoutWhitespace]
  type SubnetIdList = List[NonEmptyStringWithoutWhitespace]
  type TagDeliveryStreamInputTagList = List[zio.aws.firehose.model.Tag]
  type TagKeyList = List[TagKey]
}
