package zio.aws.firehose
import zio.aws.firehose.model.UpdateDestinationResponse.ReadOnly
import software.amazon.awssdk.services.firehose.FirehoseAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.firehose.model.{
  CreateDeliveryStreamRequest,
  DescribeDeliveryStreamRequest,
  UpdateDestinationRequest,
  UntagDeliveryStreamRequest,
  ListTagsForDeliveryStreamRequest,
  DeleteDeliveryStreamRequest,
  PutRecordRequest,
  ListDeliveryStreamsRequest,
  StopDeliveryStreamEncryptionRequest,
  StartDeliveryStreamEncryptionRequest,
  TagDeliveryStreamRequest,
  PutRecordBatchRequest
}
import zio.{IO, ZEnvironment, URLayer}
import zio.test.mock.{Proxy, Mock}
object FirehoseMock extends Mock[Firehose] {
  object ListDeliveryStreams
      extends Effect[
        ListDeliveryStreamsRequest,
        AwsError,
        zio.aws.firehose.model.ListDeliveryStreamsResponse.ReadOnly
      ]
  object PutRecord
      extends Effect[
        PutRecordRequest,
        AwsError,
        zio.aws.firehose.model.PutRecordResponse.ReadOnly
      ]
  object StopDeliveryStreamEncryption
      extends Effect[
        StopDeliveryStreamEncryptionRequest,
        AwsError,
        zio.aws.firehose.model.StopDeliveryStreamEncryptionResponse.ReadOnly
      ]
  object DeleteDeliveryStream
      extends Effect[
        DeleteDeliveryStreamRequest,
        AwsError,
        zio.aws.firehose.model.DeleteDeliveryStreamResponse.ReadOnly
      ]
  object UntagDeliveryStream
      extends Effect[
        UntagDeliveryStreamRequest,
        AwsError,
        zio.aws.firehose.model.UntagDeliveryStreamResponse.ReadOnly
      ]
  object PutRecordBatch
      extends Effect[
        PutRecordBatchRequest,
        AwsError,
        zio.aws.firehose.model.PutRecordBatchResponse.ReadOnly
      ]
  object ListTagsForDeliveryStream
      extends Effect[
        ListTagsForDeliveryStreamRequest,
        AwsError,
        zio.aws.firehose.model.ListTagsForDeliveryStreamResponse.ReadOnly
      ]
  object StartDeliveryStreamEncryption
      extends Effect[
        StartDeliveryStreamEncryptionRequest,
        AwsError,
        zio.aws.firehose.model.StartDeliveryStreamEncryptionResponse.ReadOnly
      ]
  object UpdateDestination
      extends Effect[UpdateDestinationRequest, AwsError, ReadOnly]
  object DescribeDeliveryStream
      extends Effect[
        DescribeDeliveryStreamRequest,
        AwsError,
        zio.aws.firehose.model.DescribeDeliveryStreamResponse.ReadOnly
      ]
  object TagDeliveryStream
      extends Effect[
        TagDeliveryStreamRequest,
        AwsError,
        zio.aws.firehose.model.TagDeliveryStreamResponse.ReadOnly
      ]
  object CreateDeliveryStream
      extends Effect[
        CreateDeliveryStreamRequest,
        AwsError,
        zio.aws.firehose.model.CreateDeliveryStreamResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Firehose] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Firehose {
          val api: FirehoseAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Firehose = this
          def listDeliveryStreams(request: ListDeliveryStreamsRequest): IO[
            AwsError,
            zio.aws.firehose.model.ListDeliveryStreamsResponse.ReadOnly
          ] = proxy(ListDeliveryStreams, request)
          def putRecord(
              request: PutRecordRequest
          ): IO[AwsError, zio.aws.firehose.model.PutRecordResponse.ReadOnly] =
            proxy(PutRecord, request)
          def stopDeliveryStreamEncryption(
              request: StopDeliveryStreamEncryptionRequest
          ): IO[
            AwsError,
            zio.aws.firehose.model.StopDeliveryStreamEncryptionResponse.ReadOnly
          ] = proxy(StopDeliveryStreamEncryption, request)
          def deleteDeliveryStream(request: DeleteDeliveryStreamRequest): IO[
            AwsError,
            zio.aws.firehose.model.DeleteDeliveryStreamResponse.ReadOnly
          ] = proxy(DeleteDeliveryStream, request)
          def untagDeliveryStream(request: UntagDeliveryStreamRequest): IO[
            AwsError,
            zio.aws.firehose.model.UntagDeliveryStreamResponse.ReadOnly
          ] = proxy(UntagDeliveryStream, request)
          def putRecordBatch(request: PutRecordBatchRequest): IO[
            AwsError,
            zio.aws.firehose.model.PutRecordBatchResponse.ReadOnly
          ] = proxy(PutRecordBatch, request)
          def listTagsForDeliveryStream(
              request: ListTagsForDeliveryStreamRequest
          ): IO[
            AwsError,
            zio.aws.firehose.model.ListTagsForDeliveryStreamResponse.ReadOnly
          ] = proxy(ListTagsForDeliveryStream, request)
          def startDeliveryStreamEncryption(
              request: StartDeliveryStreamEncryptionRequest
          ): IO[
            AwsError,
            zio.aws.firehose.model.StartDeliveryStreamEncryptionResponse.ReadOnly
          ] = proxy(StartDeliveryStreamEncryption, request)
          def updateDestination(
              request: UpdateDestinationRequest
          ): IO[AwsError, ReadOnly] = proxy(UpdateDestination, request)
          def describeDeliveryStream(
              request: DescribeDeliveryStreamRequest
          ): IO[
            AwsError,
            zio.aws.firehose.model.DescribeDeliveryStreamResponse.ReadOnly
          ] = proxy(DescribeDeliveryStream, request)
          def tagDeliveryStream(request: TagDeliveryStreamRequest): IO[
            AwsError,
            zio.aws.firehose.model.TagDeliveryStreamResponse.ReadOnly
          ] = proxy(TagDeliveryStream, request)
          def createDeliveryStream(request: CreateDeliveryStreamRequest): IO[
            AwsError,
            zio.aws.firehose.model.CreateDeliveryStreamResponse.ReadOnly
          ] = proxy(CreateDeliveryStream, request)
        }
      }
    }
    .toLayer
}
