package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  AmazonopensearchserviceTypeName,
  AmazonopensearchserviceClusterEndpoint,
  AmazonopensearchserviceDomainARN,
  AmazonopensearchserviceIndexName,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AmazonopensearchserviceDestinationConfiguration(
    roleARN: RoleARN,
    domainARN: Option[AmazonopensearchserviceDomainARN] = None,
    clusterEndpoint: Option[AmazonopensearchserviceClusterEndpoint] = None,
    indexName: AmazonopensearchserviceIndexName,
    typeName: Option[AmazonopensearchserviceTypeName] = None,
    indexRotationPeriod: Option[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = None,
    bufferingHints: Option[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints
    ] = None,
    retryOptions: Option[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions
    ] = None,
    s3BackupMode: Option[
      zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode
    ] = None,
    s3Configuration: zio.aws.firehose.model.S3DestinationConfiguration,
    processingConfiguration: Option[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = None,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None,
    vpcConfiguration: Option[zio.aws.firehose.model.VpcConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration = {
    import AmazonopensearchserviceDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .optionallyWith(
        domainARN.map(value =>
          AmazonopensearchserviceDomainARN.unwrap(value): java.lang.String
        )
      )(_.domainARN)
      .optionallyWith(
        clusterEndpoint.map(value =>
          AmazonopensearchserviceClusterEndpoint.unwrap(value): java.lang.String
        )
      )(_.clusterEndpoint)
      .indexName(
        AmazonopensearchserviceIndexName.unwrap(indexName): java.lang.String
      )
      .optionallyWith(
        typeName.map(value =>
          AmazonopensearchserviceTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(indexRotationPeriod.map(value => value.unwrap))(
        _.indexRotationPeriod
      )
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .s3Configuration(s3Configuration.buildAwsValue())
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration
      .wrap(buildAwsValue())
}
object AmazonopensearchserviceDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration =
      zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration(
        roleARN,
        domainARN.map(value => value),
        clusterEndpoint.map(value => value),
        indexName,
        typeName.map(value => value),
        indexRotationPeriod.map(value => value),
        bufferingHints.map(value => value.asEditable),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3Configuration.asEditable,
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        vpcConfiguration.map(value => value.asEditable)
      )
    def roleARN: RoleARN
    def domainARN: Option[AmazonopensearchserviceDomainARN]
    def clusterEndpoint: Option[AmazonopensearchserviceClusterEndpoint]
    def indexName: AmazonopensearchserviceIndexName
    def typeName: Option[AmazonopensearchserviceTypeName]
    def indexRotationPeriod: Option[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ]
    def bufferingHints: Option[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ]
    def retryOptions: Option[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ]
    def s3BackupMode
        : Option[zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode]
    def s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    def processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def vpcConfiguration
        : Option[zio.aws.firehose.model.VpcConfiguration.ReadOnly]
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getDomainARN: ZIO[Any, AwsError, AmazonopensearchserviceDomainARN] =
      AwsError.unwrapOptionField("domainARN", domainARN)
    def getClusterEndpoint
        : ZIO[Any, AwsError, AmazonopensearchserviceClusterEndpoint] =
      AwsError.unwrapOptionField("clusterEndpoint", clusterEndpoint)
    def getIndexName: ZIO[Any, Nothing, AmazonopensearchserviceIndexName] =
      ZIO.succeed(indexName)
    def getTypeName: ZIO[Any, AwsError, AmazonopensearchserviceTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getIndexRotationPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = AwsError.unwrapOptionField("indexRotationPeriod", indexRotationPeriod)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode
    ] = AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getVpcConfiguration
        : ZIO[Any, AwsError, zio.aws.firehose.model.VpcConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration
  ) extends zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val domainARN: Option[AmazonopensearchserviceDomainARN] = scala
      .Option(impl.domainARN())
      .map(value =>
        zio.aws.firehose.model.primitives
          .AmazonopensearchserviceDomainARN(value)
      )
    override val clusterEndpoint
        : Option[AmazonopensearchserviceClusterEndpoint] = scala
      .Option(impl.clusterEndpoint())
      .map(value =>
        zio.aws.firehose.model.primitives
          .AmazonopensearchserviceClusterEndpoint(value)
      )
    override val indexName: AmazonopensearchserviceIndexName =
      zio.aws.firehose.model.primitives
        .AmazonopensearchserviceIndexName(impl.indexName())
    override val typeName: Option[AmazonopensearchserviceTypeName] = scala
      .Option(impl.typeName())
      .map(value =>
        zio.aws.firehose.model.primitives.AmazonopensearchserviceTypeName(value)
      )
    override val indexRotationPeriod: Option[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = scala
      .Option(impl.indexRotationPeriod())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
          .wrap(value)
      )
    override val bufferingHints: Option[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ] = scala
      .Option(impl.bufferingHints())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.wrap(value)
      )
    override val retryOptions: Option[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ] = scala
      .Option(impl.retryOptions())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.wrap(value)
      )
    override val s3BackupMode
        : Option[zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode] =
      scala
        .Option(impl.s3BackupMode())
        .map(value =>
          zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode.wrap(value)
        )
    override val s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
      zio.aws.firehose.model.S3DestinationConfiguration
        .wrap(impl.s3Configuration())
    override val processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      scala
        .Option(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val vpcConfiguration
        : Option[zio.aws.firehose.model.VpcConfiguration.ReadOnly] = scala
      .Option(impl.vpcConfiguration())
      .map(value => zio.aws.firehose.model.VpcConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration
  ): zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
