package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  AmazonopensearchserviceTypeName,
  AmazonopensearchserviceClusterEndpoint,
  AmazonopensearchserviceDomainARN,
  AmazonopensearchserviceIndexName,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AmazonopensearchserviceDestinationDescription(
    roleARN: Option[RoleARN] = None,
    domainARN: Option[AmazonopensearchserviceDomainARN] = None,
    clusterEndpoint: Option[AmazonopensearchserviceClusterEndpoint] = None,
    indexName: Option[AmazonopensearchserviceIndexName] = None,
    typeName: Option[AmazonopensearchserviceTypeName] = None,
    indexRotationPeriod: Option[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = None,
    bufferingHints: Option[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints
    ] = None,
    retryOptions: Option[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions
    ] = None,
    s3BackupMode: Option[
      zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode
    ] = None,
    s3DestinationDescription: Option[
      zio.aws.firehose.model.S3DestinationDescription
    ] = None,
    processingConfiguration: Option[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = None,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None,
    vpcConfigurationDescription: Option[
      zio.aws.firehose.model.VpcConfigurationDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription = {
    import AmazonopensearchserviceDestinationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription
      .builder()
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        domainARN.map(value =>
          AmazonopensearchserviceDomainARN.unwrap(value): java.lang.String
        )
      )(_.domainARN)
      .optionallyWith(
        clusterEndpoint.map(value =>
          AmazonopensearchserviceClusterEndpoint.unwrap(value): java.lang.String
        )
      )(_.clusterEndpoint)
      .optionallyWith(
        indexName.map(value =>
          AmazonopensearchserviceIndexName.unwrap(value): java.lang.String
        )
      )(_.indexName)
      .optionallyWith(
        typeName.map(value =>
          AmazonopensearchserviceTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(indexRotationPeriod.map(value => value.unwrap))(
        _.indexRotationPeriod
      )
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(
        s3DestinationDescription.map(value => value.buildAwsValue())
      )(_.s3DestinationDescription)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        vpcConfigurationDescription.map(value => value.buildAwsValue())
      )(_.vpcConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription.ReadOnly =
    zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription
      .wrap(buildAwsValue())
}
object AmazonopensearchserviceDestinationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription =
      zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription(
        roleARN.map(value => value),
        domainARN.map(value => value),
        clusterEndpoint.map(value => value),
        indexName.map(value => value),
        typeName.map(value => value),
        indexRotationPeriod.map(value => value),
        bufferingHints.map(value => value.asEditable),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3DestinationDescription.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        vpcConfigurationDescription.map(value => value.asEditable)
      )
    def roleARN: Option[RoleARN]
    def domainARN: Option[AmazonopensearchserviceDomainARN]
    def clusterEndpoint: Option[AmazonopensearchserviceClusterEndpoint]
    def indexName: Option[AmazonopensearchserviceIndexName]
    def typeName: Option[AmazonopensearchserviceTypeName]
    def indexRotationPeriod: Option[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ]
    def bufferingHints: Option[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ]
    def retryOptions: Option[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ]
    def s3BackupMode
        : Option[zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode]
    def s3DestinationDescription
        : Option[zio.aws.firehose.model.S3DestinationDescription.ReadOnly]
    def processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def vpcConfigurationDescription
        : Option[zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly]
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getDomainARN: ZIO[Any, AwsError, AmazonopensearchserviceDomainARN] =
      AwsError.unwrapOptionField("domainARN", domainARN)
    def getClusterEndpoint
        : ZIO[Any, AwsError, AmazonopensearchserviceClusterEndpoint] =
      AwsError.unwrapOptionField("clusterEndpoint", clusterEndpoint)
    def getIndexName: ZIO[Any, AwsError, AmazonopensearchserviceIndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getTypeName: ZIO[Any, AwsError, AmazonopensearchserviceTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getIndexRotationPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = AwsError.unwrapOptionField("indexRotationPeriod", indexRotationPeriod)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode
    ] = AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3DestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3DestinationDescription",
      s3DestinationDescription
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getVpcConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "vpcConfigurationDescription",
      vpcConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription
  ) extends zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription.ReadOnly {
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val domainARN: Option[AmazonopensearchserviceDomainARN] = scala
      .Option(impl.domainARN())
      .map(value =>
        zio.aws.firehose.model.primitives
          .AmazonopensearchserviceDomainARN(value)
      )
    override val clusterEndpoint
        : Option[AmazonopensearchserviceClusterEndpoint] = scala
      .Option(impl.clusterEndpoint())
      .map(value =>
        zio.aws.firehose.model.primitives
          .AmazonopensearchserviceClusterEndpoint(value)
      )
    override val indexName: Option[AmazonopensearchserviceIndexName] = scala
      .Option(impl.indexName())
      .map(value =>
        zio.aws.firehose.model.primitives
          .AmazonopensearchserviceIndexName(value)
      )
    override val typeName: Option[AmazonopensearchserviceTypeName] = scala
      .Option(impl.typeName())
      .map(value =>
        zio.aws.firehose.model.primitives.AmazonopensearchserviceTypeName(value)
      )
    override val indexRotationPeriod: Option[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = scala
      .Option(impl.indexRotationPeriod())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
          .wrap(value)
      )
    override val bufferingHints: Option[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ] = scala
      .Option(impl.bufferingHints())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.wrap(value)
      )
    override val retryOptions: Option[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ] = scala
      .Option(impl.retryOptions())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.wrap(value)
      )
    override val s3BackupMode
        : Option[zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode] =
      scala
        .Option(impl.s3BackupMode())
        .map(value =>
          zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode.wrap(value)
        )
    override val s3DestinationDescription
        : Option[zio.aws.firehose.model.S3DestinationDescription.ReadOnly] =
      scala
        .Option(impl.s3DestinationDescription())
        .map(value =>
          zio.aws.firehose.model.S3DestinationDescription.wrap(value)
        )
    override val processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      scala
        .Option(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val vpcConfigurationDescription
        : Option[zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly] =
      scala
        .Option(impl.vpcConfigurationDescription())
        .map(value =>
          zio.aws.firehose.model.VpcConfigurationDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription
  ): zio.aws.firehose.model.AmazonopensearchserviceDestinationDescription.ReadOnly =
    new Wrapper(impl)
}
