package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  AmazonopensearchserviceTypeName,
  AmazonopensearchserviceClusterEndpoint,
  AmazonopensearchserviceDomainARN,
  AmazonopensearchserviceIndexName,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AmazonopensearchserviceDestinationUpdate(
    roleARN: Option[RoleARN] = None,
    domainARN: Option[AmazonopensearchserviceDomainARN] = None,
    clusterEndpoint: Option[AmazonopensearchserviceClusterEndpoint] = None,
    indexName: Option[AmazonopensearchserviceIndexName] = None,
    typeName: Option[AmazonopensearchserviceTypeName] = None,
    indexRotationPeriod: Option[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = None,
    bufferingHints: Option[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints
    ] = None,
    retryOptions: Option[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions
    ] = None,
    s3Update: Option[zio.aws.firehose.model.S3DestinationUpdate] = None,
    processingConfiguration: Option[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = None,
    cloudWatchLoggingOptions: Option[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationUpdate = {
    import AmazonopensearchserviceDestinationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationUpdate
      .builder()
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        domainARN.map(value =>
          AmazonopensearchserviceDomainARN.unwrap(value): java.lang.String
        )
      )(_.domainARN)
      .optionallyWith(
        clusterEndpoint.map(value =>
          AmazonopensearchserviceClusterEndpoint.unwrap(value): java.lang.String
        )
      )(_.clusterEndpoint)
      .optionallyWith(
        indexName.map(value =>
          AmazonopensearchserviceIndexName.unwrap(value): java.lang.String
        )
      )(_.indexName)
      .optionallyWith(
        typeName.map(value =>
          AmazonopensearchserviceTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(indexRotationPeriod.map(value => value.unwrap))(
        _.indexRotationPeriod
      )
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3Update.map(value => value.buildAwsValue()))(_.s3Update)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate.ReadOnly =
    zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate
      .wrap(buildAwsValue())
}
object AmazonopensearchserviceDestinationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate =
      zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate(
        roleARN.map(value => value),
        domainARN.map(value => value),
        clusterEndpoint.map(value => value),
        indexName.map(value => value),
        typeName.map(value => value),
        indexRotationPeriod.map(value => value),
        bufferingHints.map(value => value.asEditable),
        retryOptions.map(value => value.asEditable),
        s3Update.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable)
      )
    def roleARN: Option[RoleARN]
    def domainARN: Option[AmazonopensearchserviceDomainARN]
    def clusterEndpoint: Option[AmazonopensearchserviceClusterEndpoint]
    def indexName: Option[AmazonopensearchserviceIndexName]
    def typeName: Option[AmazonopensearchserviceTypeName]
    def indexRotationPeriod: Option[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ]
    def bufferingHints: Option[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ]
    def retryOptions: Option[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ]
    def s3Update: Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly]
    def processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getDomainARN: ZIO[Any, AwsError, AmazonopensearchserviceDomainARN] =
      AwsError.unwrapOptionField("domainARN", domainARN)
    def getClusterEndpoint
        : ZIO[Any, AwsError, AmazonopensearchserviceClusterEndpoint] =
      AwsError.unwrapOptionField("clusterEndpoint", clusterEndpoint)
    def getIndexName: ZIO[Any, AwsError, AmazonopensearchserviceIndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getTypeName: ZIO[Any, AwsError, AmazonopensearchserviceTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getIndexRotationPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = AwsError.unwrapOptionField("indexRotationPeriod", indexRotationPeriod)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3Update: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3Update", s3Update)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationUpdate
  ) extends zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate.ReadOnly {
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val domainARN: Option[AmazonopensearchserviceDomainARN] = scala
      .Option(impl.domainARN())
      .map(value =>
        zio.aws.firehose.model.primitives
          .AmazonopensearchserviceDomainARN(value)
      )
    override val clusterEndpoint
        : Option[AmazonopensearchserviceClusterEndpoint] = scala
      .Option(impl.clusterEndpoint())
      .map(value =>
        zio.aws.firehose.model.primitives
          .AmazonopensearchserviceClusterEndpoint(value)
      )
    override val indexName: Option[AmazonopensearchserviceIndexName] = scala
      .Option(impl.indexName())
      .map(value =>
        zio.aws.firehose.model.primitives
          .AmazonopensearchserviceIndexName(value)
      )
    override val typeName: Option[AmazonopensearchserviceTypeName] = scala
      .Option(impl.typeName())
      .map(value =>
        zio.aws.firehose.model.primitives.AmazonopensearchserviceTypeName(value)
      )
    override val indexRotationPeriod: Option[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = scala
      .Option(impl.indexRotationPeriod())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
          .wrap(value)
      )
    override val bufferingHints: Option[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ] = scala
      .Option(impl.bufferingHints())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.wrap(value)
      )
    override val retryOptions: Option[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ] = scala
      .Option(impl.retryOptions())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.wrap(value)
      )
    override val s3Update
        : Option[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly] = scala
      .Option(impl.s3Update())
      .map(value => zio.aws.firehose.model.S3DestinationUpdate.wrap(value))
    override val processingConfiguration
        : Option[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      scala
        .Option(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Option[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      scala
        .Option(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationUpdate
  ): zio.aws.firehose.model.AmazonopensearchserviceDestinationUpdate.ReadOnly =
    new Wrapper(impl)
}
