package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.AmazonopensearchserviceRetryDurationInSeconds
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AmazonopensearchserviceRetryOptions(
    durationInSeconds: Option[AmazonopensearchserviceRetryDurationInSeconds] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceRetryOptions = {
    import AmazonopensearchserviceRetryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceRetryOptions
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          AmazonopensearchserviceRetryDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly =
    zio.aws.firehose.model.AmazonopensearchserviceRetryOptions
      .wrap(buildAwsValue())
}
object AmazonopensearchserviceRetryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceRetryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.AmazonopensearchserviceRetryOptions =
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions(
        durationInSeconds.map(value => value)
      )
    def durationInSeconds: Option[AmazonopensearchserviceRetryDurationInSeconds]
    def getDurationInSeconds
        : ZIO[Any, AwsError, AmazonopensearchserviceRetryDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceRetryOptions
  ) extends zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly {
    override val durationInSeconds
        : Option[AmazonopensearchserviceRetryDurationInSeconds] = scala
      .Option(impl.durationInSeconds())
      .map(value =>
        zio.aws.firehose.model.primitives
          .AmazonopensearchserviceRetryDurationInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceRetryOptions
  ): zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly =
    new Wrapper(impl)
}
