package zio.aws.firehose.model
import java.lang.Integer
import zio.aws.firehose.model.primitives.{IntervalInSeconds, SizeInMBs}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BufferingHints(
    sizeInMBs: Option[SizeInMBs] = None,
    intervalInSeconds: Option[IntervalInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.BufferingHints = {
    import BufferingHints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.BufferingHints
      .builder()
      .optionallyWith(sizeInMBs.map(value => SizeInMBs.unwrap(value): Integer))(
        _.sizeInMBs
      )
      .optionallyWith(
        intervalInSeconds.map(value => IntervalInSeconds.unwrap(value): Integer)
      )(_.intervalInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.BufferingHints.ReadOnly =
    zio.aws.firehose.model.BufferingHints.wrap(buildAwsValue())
}
object BufferingHints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.BufferingHints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.BufferingHints =
      zio.aws.firehose.model.BufferingHints(
        sizeInMBs.map(value => value),
        intervalInSeconds.map(value => value)
      )
    def sizeInMBs: Option[SizeInMBs]
    def intervalInSeconds: Option[IntervalInSeconds]
    def getSizeInMBs: ZIO[Any, AwsError, SizeInMBs] =
      AwsError.unwrapOptionField("sizeInMBs", sizeInMBs)
    def getIntervalInSeconds: ZIO[Any, AwsError, IntervalInSeconds] =
      AwsError.unwrapOptionField("intervalInSeconds", intervalInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.BufferingHints
  ) extends zio.aws.firehose.model.BufferingHints.ReadOnly {
    override val sizeInMBs: Option[SizeInMBs] = scala
      .Option(impl.sizeInMBs())
      .map(value => zio.aws.firehose.model.primitives.SizeInMBs(value))
    override val intervalInSeconds: Option[IntervalInSeconds] = scala
      .Option(impl.intervalInSeconds())
      .map(value => zio.aws.firehose.model.primitives.IntervalInSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.BufferingHints
  ): zio.aws.firehose.model.BufferingHints.ReadOnly = new Wrapper(impl)
}
