package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  LogStreamName,
  LogGroupName,
  BooleanObject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CloudWatchLoggingOptions(
    enabled: Option[BooleanObject] = None,
    logGroupName: Option[LogGroupName] = None,
    logStreamName: Option[LogStreamName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions = {
    import CloudWatchLoggingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions
      .builder()
      .optionallyWith(
        enabled.map(value => BooleanObject.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        logGroupName.map(value => LogGroupName.unwrap(value): java.lang.String)
      )(_.logGroupName)
      .optionallyWith(
        logStreamName.map(value =>
          LogStreamName.unwrap(value): java.lang.String
        )
      )(_.logStreamName)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly =
    zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(buildAwsValue())
}
object CloudWatchLoggingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.CloudWatchLoggingOptions =
      zio.aws.firehose.model.CloudWatchLoggingOptions(
        enabled.map(value => value),
        logGroupName.map(value => value),
        logStreamName.map(value => value)
      )
    def enabled: Option[BooleanObject]
    def logGroupName: Option[LogGroupName]
    def logStreamName: Option[LogStreamName]
    def getEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getLogGroupName: ZIO[Any, AwsError, LogGroupName] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
    def getLogStreamName: ZIO[Any, AwsError, LogStreamName] =
      AwsError.unwrapOptionField("logStreamName", logStreamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions
  ) extends zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly {
    override val enabled: Option[BooleanObject] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.firehose.model.primitives.BooleanObject(value))
    override val logGroupName: Option[LogGroupName] = scala
      .Option(impl.logGroupName())
      .map(value => zio.aws.firehose.model.primitives.LogGroupName(value))
    override val logStreamName: Option[LogStreamName] = scala
      .Option(impl.logStreamName())
      .map(value => zio.aws.firehose.model.primitives.LogStreamName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions
  ): zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly = new Wrapper(
    impl
  )
}
