package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  CopyOptions,
  DataTableColumns,
  DataTableName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CopyCommand(
    dataTableName: DataTableName,
    dataTableColumns: Option[DataTableColumns] = None,
    copyOptions: Option[CopyOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.CopyCommand = {
    import CopyCommand.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.CopyCommand
      .builder()
      .dataTableName(DataTableName.unwrap(dataTableName): java.lang.String)
      .optionallyWith(
        dataTableColumns.map(value =>
          DataTableColumns.unwrap(value): java.lang.String
        )
      )(_.dataTableColumns)
      .optionallyWith(
        copyOptions.map(value => CopyOptions.unwrap(value): java.lang.String)
      )(_.copyOptions)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.CopyCommand.ReadOnly =
    zio.aws.firehose.model.CopyCommand.wrap(buildAwsValue())
}
object CopyCommand {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.CopyCommand
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.CopyCommand =
      zio.aws.firehose.model.CopyCommand(
        dataTableName,
        dataTableColumns.map(value => value),
        copyOptions.map(value => value)
      )
    def dataTableName: DataTableName
    def dataTableColumns: Option[DataTableColumns]
    def copyOptions: Option[CopyOptions]
    def getDataTableName: ZIO[Any, Nothing, DataTableName] =
      ZIO.succeed(dataTableName)
    def getDataTableColumns: ZIO[Any, AwsError, DataTableColumns] =
      AwsError.unwrapOptionField("dataTableColumns", dataTableColumns)
    def getCopyOptions: ZIO[Any, AwsError, CopyOptions] =
      AwsError.unwrapOptionField("copyOptions", copyOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.CopyCommand
  ) extends zio.aws.firehose.model.CopyCommand.ReadOnly {
    override val dataTableName: DataTableName =
      zio.aws.firehose.model.primitives.DataTableName(impl.dataTableName())
    override val dataTableColumns: Option[DataTableColumns] = scala
      .Option(impl.dataTableColumns())
      .map(value => zio.aws.firehose.model.primitives.DataTableColumns(value))
    override val copyOptions: Option[CopyOptions] = scala
      .Option(impl.copyOptions())
      .map(value => zio.aws.firehose.model.primitives.CopyOptions(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.CopyCommand
  ): zio.aws.firehose.model.CopyCommand.ReadOnly = new Wrapper(impl)
}
