package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.DeliveryStreamName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDeliveryStreamRequest(
    deliveryStreamName: DeliveryStreamName,
    deliveryStreamType: Option[zio.aws.firehose.model.DeliveryStreamType] =
      None,
    kinesisStreamSourceConfiguration: Option[
      zio.aws.firehose.model.KinesisStreamSourceConfiguration
    ] = None,
    deliveryStreamEncryptionConfigurationInput: Option[
      zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput
    ] = None,
    s3DestinationConfiguration: Option[
      zio.aws.firehose.model.S3DestinationConfiguration
    ] = None,
    extendedS3DestinationConfiguration: Option[
      zio.aws.firehose.model.ExtendedS3DestinationConfiguration
    ] = None,
    redshiftDestinationConfiguration: Option[
      zio.aws.firehose.model.RedshiftDestinationConfiguration
    ] = None,
    elasticsearchDestinationConfiguration: Option[
      zio.aws.firehose.model.ElasticsearchDestinationConfiguration
    ] = None,
    amazonopensearchserviceDestinationConfiguration: Option[
      zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration
    ] = None,
    splunkDestinationConfiguration: Option[
      zio.aws.firehose.model.SplunkDestinationConfiguration
    ] = None,
    httpEndpointDestinationConfiguration: Option[
      zio.aws.firehose.model.HttpEndpointDestinationConfiguration
    ] = None,
    tags: Option[Iterable[zio.aws.firehose.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest = {
    import CreateDeliveryStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .optionallyWith(deliveryStreamType.map(value => value.unwrap))(
        _.deliveryStreamType
      )
      .optionallyWith(
        kinesisStreamSourceConfiguration.map(value => value.buildAwsValue())
      )(_.kinesisStreamSourceConfiguration)
      .optionallyWith(
        deliveryStreamEncryptionConfigurationInput.map(value =>
          value.buildAwsValue()
        )
      )(_.deliveryStreamEncryptionConfigurationInput)
      .optionallyWith(
        s3DestinationConfiguration.map(value => value.buildAwsValue())
      )(_.s3DestinationConfiguration)
      .optionallyWith(
        extendedS3DestinationConfiguration.map(value => value.buildAwsValue())
      )(_.extendedS3DestinationConfiguration)
      .optionallyWith(
        redshiftDestinationConfiguration.map(value => value.buildAwsValue())
      )(_.redshiftDestinationConfiguration)
      .optionallyWith(
        elasticsearchDestinationConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.elasticsearchDestinationConfiguration)
      .optionallyWith(
        amazonopensearchserviceDestinationConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.amazonopensearchserviceDestinationConfiguration)
      .optionallyWith(
        splunkDestinationConfiguration.map(value => value.buildAwsValue())
      )(_.splunkDestinationConfiguration)
      .optionallyWith(
        httpEndpointDestinationConfiguration.map(value => value.buildAwsValue())
      )(_.httpEndpointDestinationConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.CreateDeliveryStreamRequest.ReadOnly =
    zio.aws.firehose.model.CreateDeliveryStreamRequest.wrap(buildAwsValue())
}
object CreateDeliveryStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.CreateDeliveryStreamRequest =
      zio.aws.firehose.model.CreateDeliveryStreamRequest(
        deliveryStreamName,
        deliveryStreamType.map(value => value),
        kinesisStreamSourceConfiguration.map(value => value.asEditable),
        deliveryStreamEncryptionConfigurationInput.map(value =>
          value.asEditable
        ),
        s3DestinationConfiguration.map(value => value.asEditable),
        extendedS3DestinationConfiguration.map(value => value.asEditable),
        redshiftDestinationConfiguration.map(value => value.asEditable),
        elasticsearchDestinationConfiguration.map(value => value.asEditable),
        amazonopensearchserviceDestinationConfiguration.map(value =>
          value.asEditable
        ),
        splunkDestinationConfiguration.map(value => value.asEditable),
        httpEndpointDestinationConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deliveryStreamName: DeliveryStreamName
    def deliveryStreamType: Option[zio.aws.firehose.model.DeliveryStreamType]
    def kinesisStreamSourceConfiguration: Option[
      zio.aws.firehose.model.KinesisStreamSourceConfiguration.ReadOnly
    ]
    def deliveryStreamEncryptionConfigurationInput: Option[
      zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput.ReadOnly
    ]
    def s3DestinationConfiguration
        : Option[zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly]
    def extendedS3DestinationConfiguration: Option[
      zio.aws.firehose.model.ExtendedS3DestinationConfiguration.ReadOnly
    ]
    def redshiftDestinationConfiguration: Option[
      zio.aws.firehose.model.RedshiftDestinationConfiguration.ReadOnly
    ]
    def elasticsearchDestinationConfiguration: Option[
      zio.aws.firehose.model.ElasticsearchDestinationConfiguration.ReadOnly
    ]
    def amazonopensearchserviceDestinationConfiguration: Option[
      zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration.ReadOnly
    ]
    def splunkDestinationConfiguration
        : Option[zio.aws.firehose.model.SplunkDestinationConfiguration.ReadOnly]
    def httpEndpointDestinationConfiguration: Option[
      zio.aws.firehose.model.HttpEndpointDestinationConfiguration.ReadOnly
    ]
    def tags: Option[List[zio.aws.firehose.model.Tag.ReadOnly]]
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getDeliveryStreamType
        : ZIO[Any, AwsError, zio.aws.firehose.model.DeliveryStreamType] =
      AwsError.unwrapOptionField("deliveryStreamType", deliveryStreamType)
    def getKinesisStreamSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.KinesisStreamSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisStreamSourceConfiguration",
      kinesisStreamSourceConfiguration
    )
    def getDeliveryStreamEncryptionConfigurationInput: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deliveryStreamEncryptionConfigurationInput",
      deliveryStreamEncryptionConfigurationInput
    )
    def getS3DestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3DestinationConfiguration",
      s3DestinationConfiguration
    )
    def getExtendedS3DestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ExtendedS3DestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "extendedS3DestinationConfiguration",
      extendedS3DestinationConfiguration
    )
    def getRedshiftDestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.RedshiftDestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftDestinationConfiguration",
      redshiftDestinationConfiguration
    )
    def getElasticsearchDestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ElasticsearchDestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elasticsearchDestinationConfiguration",
      elasticsearchDestinationConfiguration
    )
    def getAmazonopensearchserviceDestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amazonopensearchserviceDestinationConfiguration",
      amazonopensearchserviceDestinationConfiguration
    )
    def getSplunkDestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SplunkDestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "splunkDestinationConfiguration",
      splunkDestinationConfiguration
    )
    def getHttpEndpointDestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.HttpEndpointDestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "httpEndpointDestinationConfiguration",
      httpEndpointDestinationConfiguration
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.firehose.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest
  ) extends zio.aws.firehose.model.CreateDeliveryStreamRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val deliveryStreamType
        : Option[zio.aws.firehose.model.DeliveryStreamType] = scala
      .Option(impl.deliveryStreamType())
      .map(value => zio.aws.firehose.model.DeliveryStreamType.wrap(value))
    override val kinesisStreamSourceConfiguration: Option[
      zio.aws.firehose.model.KinesisStreamSourceConfiguration.ReadOnly
    ] = scala
      .Option(impl.kinesisStreamSourceConfiguration())
      .map(value =>
        zio.aws.firehose.model.KinesisStreamSourceConfiguration.wrap(value)
      )
    override val deliveryStreamEncryptionConfigurationInput: Option[
      zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput.ReadOnly
    ] = scala
      .Option(impl.deliveryStreamEncryptionConfigurationInput())
      .map(value =>
        zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput
          .wrap(value)
      )
    override val s3DestinationConfiguration
        : Option[zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly] =
      scala
        .Option(impl.s3DestinationConfiguration())
        .map(value =>
          zio.aws.firehose.model.S3DestinationConfiguration.wrap(value)
        )
    override val extendedS3DestinationConfiguration: Option[
      zio.aws.firehose.model.ExtendedS3DestinationConfiguration.ReadOnly
    ] = scala
      .Option(impl.extendedS3DestinationConfiguration())
      .map(value =>
        zio.aws.firehose.model.ExtendedS3DestinationConfiguration.wrap(value)
      )
    override val redshiftDestinationConfiguration: Option[
      zio.aws.firehose.model.RedshiftDestinationConfiguration.ReadOnly
    ] = scala
      .Option(impl.redshiftDestinationConfiguration())
      .map(value =>
        zio.aws.firehose.model.RedshiftDestinationConfiguration.wrap(value)
      )
    override val elasticsearchDestinationConfiguration: Option[
      zio.aws.firehose.model.ElasticsearchDestinationConfiguration.ReadOnly
    ] = scala
      .Option(impl.elasticsearchDestinationConfiguration())
      .map(value =>
        zio.aws.firehose.model.ElasticsearchDestinationConfiguration.wrap(value)
      )
    override val amazonopensearchserviceDestinationConfiguration: Option[
      zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration.ReadOnly
    ] = scala
      .Option(impl.amazonopensearchserviceDestinationConfiguration())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration
          .wrap(value)
      )
    override val splunkDestinationConfiguration: Option[
      zio.aws.firehose.model.SplunkDestinationConfiguration.ReadOnly
    ] = scala
      .Option(impl.splunkDestinationConfiguration())
      .map(value =>
        zio.aws.firehose.model.SplunkDestinationConfiguration.wrap(value)
      )
    override val httpEndpointDestinationConfiguration: Option[
      zio.aws.firehose.model.HttpEndpointDestinationConfiguration.ReadOnly
    ] = scala
      .Option(impl.httpEndpointDestinationConfiguration())
      .map(value =>
        zio.aws.firehose.model.HttpEndpointDestinationConfiguration.wrap(value)
      )
    override val tags: Option[List[zio.aws.firehose.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.firehose.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest
  ): zio.aws.firehose.model.CreateDeliveryStreamRequest.ReadOnly = new Wrapper(
    impl
  )
}
