package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.BooleanObject
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DataFormatConversionConfiguration(
    schemaConfiguration: Option[zio.aws.firehose.model.SchemaConfiguration] =
      None,
    inputFormatConfiguration: Option[
      zio.aws.firehose.model.InputFormatConfiguration
    ] = None,
    outputFormatConfiguration: Option[
      zio.aws.firehose.model.OutputFormatConfiguration
    ] = None,
    enabled: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration = {
    import DataFormatConversionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration
      .builder()
      .optionallyWith(schemaConfiguration.map(value => value.buildAwsValue()))(
        _.schemaConfiguration
      )
      .optionallyWith(
        inputFormatConfiguration.map(value => value.buildAwsValue())
      )(_.inputFormatConfiguration)
      .optionallyWith(
        outputFormatConfiguration.map(value => value.buildAwsValue())
      )(_.outputFormatConfiguration)
      .optionallyWith(
        enabled.map(value => BooleanObject.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly =
    zio.aws.firehose.model.DataFormatConversionConfiguration
      .wrap(buildAwsValue())
}
object DataFormatConversionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DataFormatConversionConfiguration =
      zio.aws.firehose.model.DataFormatConversionConfiguration(
        schemaConfiguration.map(value => value.asEditable),
        inputFormatConfiguration.map(value => value.asEditable),
        outputFormatConfiguration.map(value => value.asEditable),
        enabled.map(value => value)
      )
    def schemaConfiguration
        : Option[zio.aws.firehose.model.SchemaConfiguration.ReadOnly]
    def inputFormatConfiguration
        : Option[zio.aws.firehose.model.InputFormatConfiguration.ReadOnly]
    def outputFormatConfiguration
        : Option[zio.aws.firehose.model.OutputFormatConfiguration.ReadOnly]
    def enabled: Option[BooleanObject]
    def getSchemaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SchemaConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("schemaConfiguration", schemaConfiguration)
    def getInputFormatConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.InputFormatConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputFormatConfiguration",
      inputFormatConfiguration
    )
    def getOutputFormatConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.OutputFormatConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "outputFormatConfiguration",
      outputFormatConfiguration
    )
    def getEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration
  ) extends zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly {
    override val schemaConfiguration
        : Option[zio.aws.firehose.model.SchemaConfiguration.ReadOnly] = scala
      .Option(impl.schemaConfiguration())
      .map(value => zio.aws.firehose.model.SchemaConfiguration.wrap(value))
    override val inputFormatConfiguration
        : Option[zio.aws.firehose.model.InputFormatConfiguration.ReadOnly] =
      scala
        .Option(impl.inputFormatConfiguration())
        .map(value =>
          zio.aws.firehose.model.InputFormatConfiguration.wrap(value)
        )
    override val outputFormatConfiguration
        : Option[zio.aws.firehose.model.OutputFormatConfiguration.ReadOnly] =
      scala
        .Option(impl.outputFormatConfiguration())
        .map(value =>
          zio.aws.firehose.model.OutputFormatConfiguration.wrap(value)
        )
    override val enabled: Option[BooleanObject] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.firehose.model.primitives.BooleanObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration
  ): zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly =
    new Wrapper(impl)
}
