package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{BooleanObject, DeliveryStreamName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDeliveryStreamRequest(
    deliveryStreamName: DeliveryStreamName,
    allowForceDelete: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamRequest = {
    import DeleteDeliveryStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamRequest
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .optionallyWith(
        allowForceDelete.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.allowForceDelete)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.DeleteDeliveryStreamRequest.ReadOnly =
    zio.aws.firehose.model.DeleteDeliveryStreamRequest.wrap(buildAwsValue())
}
object DeleteDeliveryStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DeleteDeliveryStreamRequest =
      zio.aws.firehose.model.DeleteDeliveryStreamRequest(
        deliveryStreamName,
        allowForceDelete.map(value => value)
      )
    def deliveryStreamName: DeliveryStreamName
    def allowForceDelete: Option[BooleanObject]
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getAllowForceDelete: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("allowForceDelete", allowForceDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamRequest
  ) extends zio.aws.firehose.model.DeleteDeliveryStreamRequest.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val allowForceDelete: Option[BooleanObject] = scala
      .Option(impl.allowForceDelete())
      .map(value => zio.aws.firehose.model.primitives.BooleanObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamRequest
  ): zio.aws.firehose.model.DeleteDeliveryStreamRequest.ReadOnly = new Wrapper(
    impl
  )
}
