package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.AWSKMSKeyARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeliveryStreamEncryptionConfiguration(
    keyARN: Option[AWSKMSKeyARN] = None,
    keyType: Option[zio.aws.firehose.model.KeyType] = None,
    status: Option[zio.aws.firehose.model.DeliveryStreamEncryptionStatus] =
      None,
    failureDescription: Option[zio.aws.firehose.model.FailureDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfiguration = {
    import DeliveryStreamEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfiguration
      .builder()
      .optionallyWith(
        keyARN.map(value => AWSKMSKeyARN.unwrap(value): java.lang.String)
      )(_.keyARN)
      .optionallyWith(keyType.map(value => value.unwrap))(_.keyType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(failureDescription.map(value => value.buildAwsValue()))(
        _.failureDescription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration.ReadOnly =
    zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration
      .wrap(buildAwsValue())
}
object DeliveryStreamEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration =
      zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration(
        keyARN.map(value => value),
        keyType.map(value => value),
        status.map(value => value),
        failureDescription.map(value => value.asEditable)
      )
    def keyARN: Option[AWSKMSKeyARN]
    def keyType: Option[zio.aws.firehose.model.KeyType]
    def status: Option[zio.aws.firehose.model.DeliveryStreamEncryptionStatus]
    def failureDescription
        : Option[zio.aws.firehose.model.FailureDescription.ReadOnly]
    def getKeyARN: ZIO[Any, AwsError, AWSKMSKeyARN] =
      AwsError.unwrapOptionField("keyARN", keyARN)
    def getKeyType: ZIO[Any, AwsError, zio.aws.firehose.model.KeyType] =
      AwsError.unwrapOptionField("keyType", keyType)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DeliveryStreamEncryptionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailureDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.FailureDescription.ReadOnly
    ] = AwsError.unwrapOptionField("failureDescription", failureDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfiguration
  ) extends zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration.ReadOnly {
    override val keyARN: Option[AWSKMSKeyARN] = scala
      .Option(impl.keyARN())
      .map(value => zio.aws.firehose.model.primitives.AWSKMSKeyARN(value))
    override val keyType: Option[zio.aws.firehose.model.KeyType] = scala
      .Option(impl.keyType())
      .map(value => zio.aws.firehose.model.KeyType.wrap(value))
    override val status
        : Option[zio.aws.firehose.model.DeliveryStreamEncryptionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.firehose.model.DeliveryStreamEncryptionStatus.wrap(value)
      )
    override val failureDescription
        : Option[zio.aws.firehose.model.FailureDescription.ReadOnly] = scala
      .Option(impl.failureDescription())
      .map(value => zio.aws.firehose.model.FailureDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfiguration
  ): zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
