package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.AWSKMSKeyARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeliveryStreamEncryptionConfigurationInput(
    keyARN: Option[AWSKMSKeyARN] = None,
    keyType: zio.aws.firehose.model.KeyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfigurationInput = {
    import DeliveryStreamEncryptionConfigurationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfigurationInput
      .builder()
      .optionallyWith(
        keyARN.map(value => AWSKMSKeyARN.unwrap(value): java.lang.String)
      )(_.keyARN)
      .keyType(keyType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput.ReadOnly =
    zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput
      .wrap(buildAwsValue())
}
object DeliveryStreamEncryptionConfigurationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfigurationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput =
      zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput(
        keyARN.map(value => value),
        keyType
      )
    def keyARN: Option[AWSKMSKeyARN]
    def keyType: zio.aws.firehose.model.KeyType
    def getKeyARN: ZIO[Any, AwsError, AWSKMSKeyARN] =
      AwsError.unwrapOptionField("keyARN", keyARN)
    def getKeyType: ZIO[Any, Nothing, zio.aws.firehose.model.KeyType] =
      ZIO.succeed(keyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfigurationInput
  ) extends zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput.ReadOnly {
    override val keyARN: Option[AWSKMSKeyARN] = scala
      .Option(impl.keyARN())
      .map(value => zio.aws.firehose.model.primitives.AWSKMSKeyARN(value))
    override val keyType: zio.aws.firehose.model.KeyType =
      zio.aws.firehose.model.KeyType.wrap(impl.keyType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfigurationInput
  ): zio.aws.firehose.model.DeliveryStreamEncryptionConfigurationInput.ReadOnly =
    new Wrapper(impl)
}
