package zio.aws.firehose.model
import scala.jdk.CollectionConverters.*
sealed trait DeliveryStreamStatus {
  def unwrap
      : software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus
}
object DeliveryStreamStatus {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus
  ): zio.aws.firehose.model.DeliveryStreamStatus = value match {
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.CREATING_FAILED =>
      val r = CREATING_FAILED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.DELETING_FAILED =>
      val r = DELETING_FAILED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.DeliveryStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.firehose.model.DeliveryStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.CREATING
  }
  case object CREATING_FAILED
      extends zio.aws.firehose.model.DeliveryStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.CREATING_FAILED
  }
  case object DELETING extends zio.aws.firehose.model.DeliveryStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.DELETING
  }
  case object DELETING_FAILED
      extends zio.aws.firehose.model.DeliveryStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.DELETING_FAILED
  }
  case object ACTIVE extends zio.aws.firehose.model.DeliveryStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus.ACTIVE
  }
}
